//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ eLXgVRAM ]
//
//---------------------------------------------------------------------------

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "log.h"
#include "fileio.h"
#include "schedule.h"
#include "render.h"
#include "renderin.h"
#include "tvram.h"

//===========================================================================
//
//	eLXgVRAMnh
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
TVRAMHandler::TVRAMHandler(Render *rend, BYTE *mem)
{
	ASSERT(rend);
	ASSERT(mem);

	// L
	render = rend;
	tvram = mem;

	// [N
	multi = 0;
	mask = 0;
	rev = 0;
	maskh = 0;
	revh = 0;
}

//===========================================================================
//
//	eLXgVRAMnh(m[})
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
TVRAMNormal::TVRAMNormal(Render *rend, BYTE *mem) : TVRAMHandler(rend, mem)
{
}

//---------------------------------------------------------------------------
//
//	oCg
//
//---------------------------------------------------------------------------
void FASTCALL TVRAMNormal::WriteByte(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT(addr < 0x80000);
	ASSERT(data < 0x100);

	if (tvram[addr] != data) {
		tvram[addr] = (BYTE)data;
		render->TextMem(addr);
	}
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
void FASTCALL TVRAMNormal::WriteWord(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT(addr < 0x80000);
	ASSERT(data < 0x10000);

	if ((DWORD)*(WORD*)(&tvram[addr]) != data) {
		*(WORD*)(&tvram[addr]) = (WORD)data;
		render->TextMem(addr);
	}
}

//===========================================================================
//
//	eLXgVRAMnh(}XN)
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
TVRAMMask::TVRAMMask(Render *rend, BYTE *mem) : TVRAMHandler(rend, mem)
{
}

//---------------------------------------------------------------------------
//
//	oCg
//
//---------------------------------------------------------------------------
void FASTCALL TVRAMMask::WriteByte(DWORD addr, DWORD data)
{
	DWORD mem;

	ASSERT(this);
	ASSERT(addr < 0x80000);
	ASSERT(data < 0x100);

	// mask1͕ύXȂA0͕ύX
	mem = (DWORD)tvram[addr];
	if (addr & 1) {
		// 68000ł͋AhXb15-b8g
		mem &= maskh;
		data &= revh;
	}
	else {
		// 68000ł͊AhXb7-b0g
		mem &= mask;
		data &= rev;
	}

	// 
	data |= mem;

	// 
	if (tvram[addr] != data) {
		tvram[addr] = (BYTE)data;
		render->TextMem(addr);
	}
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
void FASTCALL TVRAMMask::WriteWord(DWORD addr, DWORD data)
{
	DWORD mem;

	ASSERT(this);
	ASSERT(addr < 0x80000);
	ASSERT(data < 0x10000);

	// mask1͕ύXȂA0͕ύX
	mem = (DWORD)*(WORD*)(&tvram[addr]);
	mem &= mask;
	data &= rev;

	// 
	data |= mem;

	if ((DWORD)*(WORD*)(&tvram[addr]) != data) {
		*(WORD*)(&tvram[addr]) = (WORD)data;
		render->TextMem(addr);
	}
}

//===========================================================================
//
//	eLXgVRAMnh(}`)
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
TVRAMMulti::TVRAMMulti(Render *rend, BYTE *mem) : TVRAMHandler(rend, mem)
{
}

//---------------------------------------------------------------------------
//
//	oCg
//
//---------------------------------------------------------------------------
void FASTCALL TVRAMMulti::WriteByte(DWORD addr, DWORD data)
{
	BOOL flag;

	ASSERT(this);
	ASSERT(addr < 0x80000);
	ASSERT(data < 0x100);

	// 
	addr &= 0x1ffff;
	flag = FALSE;

	// v[B
	if (multi & 1) {
		if (tvram[addr] != data) {
			tvram[addr] = (BYTE)data;
			flag = TRUE;
		}
	}
	addr += 0x20000;

	// v[G
	if (multi & 2) {
		if (tvram[addr] != data) {
			tvram[addr] = (BYTE)data;
			flag = TRUE;
		}
	}
	addr += 0x20000;

	// v[R
	if (multi & 4) {
		if (tvram[addr] != data) {
			tvram[addr] = (BYTE)data;
			flag = TRUE;
		}
	}
	addr += 0x20000;

	// v[I
	if (multi & 8) {
		if (tvram[addr] != data) {
			tvram[addr] = (BYTE)data;
			flag = TRUE;
		}
	}

	// _֒ʒm
	if (flag) {
		render->TextMem(addr);
	}
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
void FASTCALL TVRAMMulti::WriteWord(DWORD addr, DWORD data)
{
	BOOL flag;

	ASSERT(this);
	ASSERT(addr < 0x80000);
	ASSERT(data < 0x10000);

	// 
	addr &= 0x1fffe;
	flag = FALSE;

	// v[B
	if (multi & 1) {
		if ((DWORD)*(WORD*)(&tvram[addr]) != data) {
			*(WORD*)(&tvram[addr]) = (WORD)data;
			flag = TRUE;
		}
	}
	addr += 0x20000;

	// v[G
	if (multi & 2) {
		if ((DWORD)*(WORD*)(&tvram[addr]) != data) {
			*(WORD*)(&tvram[addr]) = (WORD)data;
			flag = TRUE;
		}
	}
	addr += 0x20000;

	// v[R
	if (multi & 4) {
		if ((DWORD)*(WORD*)(&tvram[addr]) != data) {
			*(WORD*)(&tvram[addr]) = (WORD)data;
			flag = TRUE;
		}
	}
	addr += 0x20000;

	// v[I
	if (multi & 8) {
		if ((DWORD)*(WORD*)(&tvram[addr]) != data) {
			*(WORD*)(&tvram[addr]) = (WORD)data;
			flag = TRUE;
		}
	}

	// _֒ʒm
	if (flag) {
		render->TextMem(addr);
	}
}

//===========================================================================
//
//	eLXgVRAMnh()
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
TVRAMBoth::TVRAMBoth(Render *rend, BYTE *mem) : TVRAMHandler(rend, mem)
{
}

//---------------------------------------------------------------------------
//
//	oCg
//
//---------------------------------------------------------------------------
void FASTCALL TVRAMBoth::WriteByte(DWORD addr, DWORD data)
{
	DWORD mem;
	DWORD maskhl;
	BOOL flag;

	ASSERT(this);
	ASSERT(addr < 0x80000);
	ASSERT(data < 0x100);

	// E̔͐ɍς܂
	if (addr & 1) {
		maskhl = maskh;
		data &= revh;
	}
	else {
		maskhl = mask;
		data &= rev;
	}

	// 
	addr &= 0x1ffff;
	flag = FALSE;

	// v[B
	if (multi & 1) {
		mem = (DWORD)tvram[addr];
		mem &= maskhl;
		mem |= data;

		if (tvram[addr] != mem) {
			tvram[addr] = (BYTE)mem;
			flag = TRUE;
		}
	}
	addr += 0x20000;

	// v[G
	if (multi & 2) {
		mem = (DWORD)tvram[addr];
		mem &= maskhl;
		mem |= data;

		if (tvram[addr] != mem) {
			tvram[addr] = (BYTE)mem;
			flag = TRUE;
		}
	}
	addr += 0x20000;

	// v[R
	if (multi & 4) {
		mem = (DWORD)tvram[addr];
		mem &= maskhl;
		mem |= data;

		if (tvram[addr] != mem) {
			tvram[addr] = (BYTE)mem;
			flag = TRUE;
		}
	}
	addr += 0x20000;

	// v[I
	if (multi & 8) {
		mem = (DWORD)tvram[addr];
		mem &= maskhl;
		mem |= data;

		if (tvram[addr] != mem) {
			tvram[addr] = (BYTE)mem;
			flag = TRUE;
		}
	}

	// _֒ʒm
	if (flag) {
		render->TextMem(addr);
	}
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
void FASTCALL TVRAMBoth::WriteWord(DWORD addr, DWORD data)
{
	DWORD mem;
	BOOL flag;

	ASSERT(this);
	ASSERT(addr < 0x80000);
	ASSERT(data < 0x10000);

	// f[^͐Ƀ}XNĂ
	data &= rev;

	// 
	addr &= 0x1fffe;
	flag = FALSE;

	// v[B
	if (multi & 1) {
		mem = (DWORD)*(WORD*)(&tvram[addr]);
		mem &= mask;
		mem |= data;

		if ((DWORD)*(WORD*)(&tvram[addr]) != mem) {
			*(WORD*)(&tvram[addr]) = (WORD)mem;
			flag = TRUE;
		}
	}
	addr += 0x20000;

	// v[G
	if (multi & 2) {
		mem = (DWORD)*(WORD*)(&tvram[addr]);
		mem &= mask;
		mem |= data;

		if ((DWORD)*(WORD*)(&tvram[addr]) != mem) {
			*(WORD*)(&tvram[addr]) = (WORD)mem;
			flag = TRUE;
		}
	}
	addr += 0x20000;

	// v[R
	if (multi & 4) {
		mem = (DWORD)*(WORD*)(&tvram[addr]);
		mem &= mask;
		mem |= data;

		if ((DWORD)*(WORD*)(&tvram[addr]) != mem) {
			*(WORD*)(&tvram[addr]) = (WORD)mem;
			flag = TRUE;
		}
	}
	addr += 0x20000;

	// v[I
	if (multi & 8) {
		mem = (DWORD)*(WORD*)(&tvram[addr]);
		mem &= mask;
		mem |= data;

		if ((DWORD)*(WORD*)(&tvram[addr]) != mem) {
			*(WORD*)(&tvram[addr]) = (WORD)mem;
			flag = TRUE;
		}
	}

	// _֒ʒm
	if (flag) {
		render->TextMem(addr);
	}
}

//===========================================================================
//
//	eLXgVRAM
//
//===========================================================================
//#define TVRAM_LOG

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
TVRAM::TVRAM(VM *p) : MemDevice(p)
{
	// foCXID
	dev.id = MAKEID('T', 'V', 'R', 'M');
	dev.desc = "Text VRAM";

	// JnAhXAIAhX
	memdev.first = 0xe00000;
	memdev.last = 0xe7ffff;

	// nh
	normal = NULL;
	mask = NULL;
	multi = NULL;
	both = NULL;

	// ̑
	render = NULL;
	tvram = NULL;
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL TVRAM::Init()
{
	ASSERT(this);

	// {NX
	if (!MemDevice::Init()) {
		return FALSE;
	}

	// _擾
	render = (Render*)vm->SearchDevice(MAKEID('R', 'E', 'N', 'D'));
	ASSERT(render);

	// mہANA
	try {
		tvram = new BYTE[ 0x80000 ];
	}
	catch (...) {
		return FALSE;
	}
	if (!tvram) {
		return FALSE;
	}
	memset(tvram, 0, 0x80000);

	// nh쐬
	normal = new TVRAMNormal(render, tvram);
	mask = new TVRAMMask(render, tvram);
	multi = new TVRAMMulti(render, tvram);
	both = new TVRAMBoth(render, tvram);
	handler = normal;

	// [NGA
	tvdata.multi = 0;
	tvdata.mask = 0;
	tvdata.rev = 0xffffffff;
	tvdata.maskh = 0;
	tvdata.revh = 0xffffffff;
	tvdata.src = 0;
	tvdata.dst = 0;
	tvdata.plane = 0;
	tvcount = 0;

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL TVRAM::Cleanup()
{
	ASSERT(this);

	// nh폜
	if (both) {
		delete both;
		both = NULL;
	}
	if (multi) {
		delete multi;
		multi = NULL;
	}
	if (mask) {
		delete mask;
		mask = NULL;
	}
	if (normal) {
		delete normal;
		normal = NULL;
	}
	handler = NULL;

	// 
	delete[] tvram;
	tvram = NULL;

	// {NX
	MemDevice::Cleanup();
}

//---------------------------------------------------------------------------
//
//	Zbg
//
//---------------------------------------------------------------------------
void FASTCALL TVRAM::Reset()
{
	ASSERT(this);
	ASSERT_DIAG();

	LOG0(Log::Normal, "Zbg");

	// [NGA
	tvdata.multi = 0;
	tvdata.mask = 0;
	tvdata.rev = 0xffffffff;
	tvdata.maskh = 0;
	tvdata.revh = 0xffffffff;
	tvdata.src = 0;
	tvdata.dst = 0;
	tvdata.plane = 0;

	// ANZXJEg0
	tvcount = 0;

	// nh̓m[}
	handler = normal;
	ASSERT(handler);
}

//---------------------------------------------------------------------------
//
//	Z[u
//
//---------------------------------------------------------------------------
BOOL FASTCALL TVRAM::Save(Fileio *fio, int /*ver*/)
{
	size_t sz;

	ASSERT(this);
	ASSERT(fio);
	ASSERT_DIAG();

	LOG0(Log::Normal, "Z[u");

	// Z[u
	if (!fio->Write(tvram, 0x80000)) {
		return FALSE;
	}

	// TCYZ[u
	sz = sizeof(tvram_t);
	if (!fio->Write(&sz, sizeof(sz))) {
		return FALSE;
	}

	// ̂Z[u
	if (!fio->Write(&tvdata, (int)sz)) {
		return FALSE;
	}

	// tvcount(version2.04Œǉ)
	if (!fio->Write(&tvcount, sizeof(tvcount))) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
BOOL FASTCALL TVRAM::Load(Fileio *fio, int ver)
{
	size_t sz;
	DWORD addr;

	ASSERT(this);
	ASSERT(fio);
	ASSERT(ver >= 0x0200);
	ASSERT_DIAG();

	LOG0(Log::Normal, "[h");

	// [h
	if (!fio->Read(tvram, 0x80000)) {
		return FALSE;
	}

	// TCY[hAƍ
	if (!fio->Read(&sz, sizeof(sz))) {
		return FALSE;
	}
	if (sz != sizeof(tvram_t)) {
		return FALSE;
	}

	// ̂[h
	if (!fio->Read(&tvdata, (int)sz)) {
		return FALSE;
	}

	// tvcount(version2.04Œǉ)
	tvcount = 0;
	if (ver >= 0x0204) {
		if (!fio->Read(&tvcount, sizeof(tvcount))) {
			return FALSE;
		}
	}

	// _֒ʒm
	for(addr=0; addr<0x20000; addr++) {
		render->TextMem(addr);
	}

	// nhݒ
	SelectHandler();

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL TVRAM::ApplyCfg(const Config* /*config*/)
{
	ASSERT(this);
	ASSERT_DIAG();

	LOG0(Log::Normal, "ݒKp");
}

#if !defined(NDEBUG)
//---------------------------------------------------------------------------
//
//	ff
//
//---------------------------------------------------------------------------
void FASTCALL TVRAM::AssertDiag() const
{
	// {NX
	MemDevice::AssertDiag();

	ASSERT(this);
	ASSERT(GetID() == MAKEID('T', 'V', 'R', 'M'));
	ASSERT(memdev.first == 0xe00000);
	ASSERT(memdev.last == 0xe7ffff);
	ASSERT(tvram);
	ASSERT(normal);
	ASSERT(mask);
	ASSERT(multi);
	ASSERT(both);
	ASSERT(handler);
	ASSERT(tvdata.multi <= 0x1f);
	ASSERT(tvdata.mask < 0x10000);
	ASSERT(tvdata.rev >= 0xffff0000);
	ASSERT(tvdata.maskh < 0x100);
	ASSERT(tvdata.revh >= 0xffffff00);
	ASSERT(tvdata.src < 0x100);
	ASSERT(tvdata.dst < 0x100);
	ASSERT(tvdata.plane <= 0x0f);
}
#endif	// NDEBUG

//---------------------------------------------------------------------------
//
//	oCgǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL TVRAM::ReadByte(DWORD addr)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));
	ASSERT_DIAG();

	// EFCg(0.75EFCg)
	tvcount++;
	if (tvcount & 3) {
		scheduler->Wait(1);
	}

	// GfBA𔽓]ēǂݍ
	return (DWORD)tvram[(addr & 0x7ffff) ^ 1];
}

//---------------------------------------------------------------------------
//
//	[hǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL TVRAM::ReadWord(DWORD addr)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));
	ASSERT((addr & 1) == 0);
	ASSERT_DIAG();

	// EFCg(0.75EFCg)
	tvcount++;
	if (tvcount & 3) {
		scheduler->Wait(1);
	}

	// ǂݍ
	return (DWORD)*(WORD *)(&tvram[addr & 0x7ffff]);
}

//---------------------------------------------------------------------------
//
//	oCg
//
//---------------------------------------------------------------------------
void FASTCALL TVRAM::WriteByte(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));
	ASSERT(data < 0x100);
	ASSERT_DIAG();

	// EFCg(0.75EFCg)
	tvcount++;
	if (tvcount & 3) {
		scheduler->Wait(1);
	}

	// 
	handler->WriteByte((addr & 0x7ffff) ^ 1, data);
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
void FASTCALL TVRAM::WriteWord(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));
	ASSERT((addr & 1) == 0);
	ASSERT(data < 0x10000);
	ASSERT_DIAG();

	// EFCg(0.75EFCg)
	tvcount++;
	if (tvcount & 3) {
		scheduler->Wait(1);
	}

	// 
	handler->WriteWord(addr & 0x7ffff, data);
}

//---------------------------------------------------------------------------
//
//	ǂݍ݂̂
//
//---------------------------------------------------------------------------
DWORD FASTCALL TVRAM::ReadOnly(DWORD addr) const
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));
	ASSERT_DIAG();

	// GfBA𔽓]ēǂݍ
	return tvram[(addr & 0x7ffff) ^ 1];
}

//---------------------------------------------------------------------------
//
//	TVRAM擾
//
//---------------------------------------------------------------------------
const BYTE* FASTCALL TVRAM::GetTVRAM() const
{
	ASSERT(this);
	ASSERT_DIAG();

	return tvram;
}

//---------------------------------------------------------------------------
//
//	ݐݒ
//
//---------------------------------------------------------------------------
void FASTCALL TVRAM::SetMulti(DWORD data)
{
	ASSERT(this);
	ASSERT(data <= 0x1f);
	ASSERT_DIAG();

	// v`FbN
	if (tvdata.multi == data) {
		return;
	}

	// f[^Rs[
	tvdata.multi = data;

	// nhI
	SelectHandler();
}

//---------------------------------------------------------------------------
//
//	ANZX}XNݒ
//
//---------------------------------------------------------------------------
void FASTCALL TVRAM::SetMask(DWORD data)
{
	ASSERT(this);
	ASSERT(data < 0x10000);
	ASSERT_DIAG();

	// v`FbN
	if (tvdata.mask == data) {
		return;
	}

	// f[^Rs[
	tvdata.mask = data;
	tvdata.rev = ~tvdata.mask;
	tvdata.maskh = tvdata.mask >> 8;
	tvdata.revh = ~tvdata.maskh;

	// nhI
	SelectHandler();
}

//---------------------------------------------------------------------------
//
//	nhI
//
//---------------------------------------------------------------------------
void FASTCALL TVRAM::SelectHandler()
{
	ASSERT(this);
	ASSERT_DIAG();

	// ʏ
	handler = normal;

	// }``FbN
	if (tvdata.multi != 0) {
		// }XNƕp
		if (tvdata.mask != 0) {
			// 
			handler = both;

			// }`f[^ݒ
			handler->multi = tvdata.multi;

			// }XNf[^ݒ
			handler->mask = tvdata.mask;
			handler->rev = tvdata.rev;
			handler->maskh = tvdata.maskh;
			handler->revh = tvdata.revh;
		}
		else {
			// }`
			handler = multi;

			// }`f[^ݒ
			handler->multi = tvdata.multi;
		}
		return;
	}

	// }XN`FbN
	if (tvdata.mask != 0) {
		// }XN
		handler = mask;

		// }XNf[^ݒ
		handler->mask = tvdata.mask;
		handler->rev = tvdata.rev;
		handler->maskh = tvdata.maskh;
		handler->revh = tvdata.revh;
	}
}

//---------------------------------------------------------------------------
//
//	X^Rs[ݒ
//
//---------------------------------------------------------------------------
void FASTCALL TVRAM::SetCopyRaster(DWORD src, DWORD dst, DWORD plane)
{
	ASSERT(this);
	ASSERT(src < 0x100);
	ASSERT(dst < 0x100);
	ASSERT(plane <= 0x0f);
	ASSERT_DIAG();

	tvdata.src = src;
	tvdata.dst = dst;
	tvdata.plane = plane;
}

//---------------------------------------------------------------------------
//
//	X^Rs[s
//
//---------------------------------------------------------------------------
void FASTCALL TVRAM::RasterCopy()
{
	ASSERT(this);
	ASSERT_DIAG();
#if 0
	DWORD *p;
	DWORD *q;
	int i;
	int j;
	DWORD plane;

	// |C^Av[
	p = (DWORD*)&tvram[tvdata.src << 9];
	q = (DWORD*)&tvram[tvdata.dst << 9];
	plane = tvdata.plane;

	// v[ʂɍs
	for (i=0; i<4; i++) {
		if (plane & 1) {
			for (j=7; j>=0; j--) {
				q[0] = p[0];
				q[1] = p[1];
				q[2] = p[2];
				q[3] = p[3];
				q[4] = p[4];
				q[5] = p[5];
				q[6] = p[6];
				q[7] = p[7];
				q[8] = p[8];
				q[9] = p[9];
				q[10] = p[10];
				q[11] = p[11];
				q[12] = p[12];
				q[13] = p[13];
				q[14] = p[14];
				q[15] = p[15];
				p += 16;
				q += 16;
			}
			p -= 128;
			q -= 128;
		}
		p += 0x8000;
		q += 0x8000;
		plane >>= 1;
	}

	// _ɁARs[̃GAuƂʒm
	plane = tvdata.dst;
	plane <<= 9;
	for (i=0; i<0x200; i++) {
		render->TextMem(plane + i);
	}
#endif
	// _Ă
	if (tvdata.plane != 0) {
		render->TextCopy(tvdata.src, tvdata.dst, tvdata.plane);
	}
}
