//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ eLXgVRAM ]
//
//---------------------------------------------------------------------------

#if !defined(tvram_h)
#define tvram_h

#include "device.h"

//===========================================================================
//
//	eLXgVRAMnh
//
//===========================================================================
class TVRAMHandler
{
public:
	TVRAMHandler(Render *rend, BYTE *mem);
										// RXgN^
	virtual void FASTCALL WriteByte(DWORD addr, DWORD data) = 0;
										// oCg
	virtual void FASTCALL WriteWord(DWORD addr, DWORD data) = 0;
										// [h

	// TVRAM[ÑRs[
	DWORD multi;
										// ANZX(bit0-bit3)
	DWORD mask;
										// ANZX}XN(1ŕύXȂ)
	DWORD rev;
										// ANZX}XN]
	DWORD maskh;
										// ANZX}XNʃoCg
	DWORD revh;
										// ANZX}XNʔ]

protected:
	Render *render;
										// _
	BYTE *tvram;
										// eLXgVRAM
};

//===========================================================================
//
//	eLXgVRAMnh(ʏ)
//
//===========================================================================
class TVRAMNormal : public TVRAMHandler
{
public:
	TVRAMNormal(Render *rend, BYTE *mem);
										// RXgN^
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
};

//===========================================================================
//
//	eLXgVRAMnh(}XN)
//
//===========================================================================
class TVRAMMask : public TVRAMHandler
{
public:
	TVRAMMask(Render *rend, BYTE *mem);
										// RXgN^
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
};

//===========================================================================
//
//	eLXgVRAMnh(}`)
//
//===========================================================================
class TVRAMMulti : public TVRAMHandler
{
public:
	TVRAMMulti(Render *rend, BYTE *mem);
										// RXgN^
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
};

//===========================================================================
//
//	eLXgVRAMnh(}XN{}`)
//
//===========================================================================
class TVRAMBoth : public TVRAMHandler
{
public:
	TVRAMBoth(Render *rend, BYTE *mem);
										// RXgN^
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
};

//===========================================================================
//
//	eLXgVRAM
//
//===========================================================================
class TVRAM : public MemDevice
{
public:
	// f[^`
	typedef struct {
		DWORD multi;					// ANZX(bit0-bit3)
		DWORD mask;						// ANZX}XN(1ŕύXȂ)
		DWORD rev;						// ANZX}XN]
		DWORD maskh;					// ANZX}XNʃoCg
		DWORD revh;						// ANZX}XNʔ]
		DWORD src;						// X^Rs[ X^
		DWORD dst;						// X^Rs[ 惉X^
		DWORD plane;					// X^Rs[ Ώۃv[
	} tvram_t;

public:
	// {t@NV
	TVRAM(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp
#if !defined(NDEBUG)
	void FASTCALL AssertDiag() const;
										// ff
#endif	// NDEBUG

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	const BYTE* FASTCALL GetTVRAM() const;
										// TVRAM擾
	void FASTCALL SetMulti(DWORD data);
										// ݐݒ
	void FASTCALL SetMask(DWORD data);
										// ANZX}XNݒ
	void FASTCALL SetCopyRaster(DWORD src, DWORD dst, DWORD plane);
										// Rs[X^w
	void FASTCALL RasterCopy();
										// X^Rs[

private:
	void FASTCALL SelectHandler();
										// nhI
	TVRAMNormal *normal;
										// nh(ʏ)
	TVRAMMask *mask;
										// nh(}XN)
	TVRAMMulti *multi;
										// nh(}`)
	TVRAMBoth *both;
										// nh()
	TVRAMHandler *handler;
										// nh(ݑI)
	Render *render;
										// _
	BYTE *tvram;
										// eLXgVRAM (512KB)
	tvram_t tvdata;
										// f[^
	DWORD tvcount;
										// TVRAMANZXJEg(version2.04ȍ~)
};

#endif	// tvram_h
