//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2005 ohD(ytanaka@ipc-tokai.or.jp)
//	[ rfIRg[(CATHY & VIPS) ]
//
//---------------------------------------------------------------------------

#if !defined(vc_h)
#define vc_h

#include "device.h"

//===========================================================================
//
//	rfIRg[
//
//===========================================================================
class VC : public MemDevice
{
public:
	// f[^`
	typedef struct {
		DWORD vr1h;						// VR1(H)obNAbv
		DWORD vr1l;						// VR1(H)obNAbv
		DWORD vr2h;						// VR2(H)obNAbv
		DWORD vr2l;						// VR2(H)obNAbv
		BOOL siz;						// ʃTCY
		DWORD col;						// F[h
		DWORD sp;						// XvCgvCIeB
		DWORD tx;						// eLXgvCIeB
		DWORD gr;						// OtBbNvCIeB(1024)
		DWORD gp[4];					// OtBbNvCIeB(512)
		BOOL ys;						// YsM
		BOOL ah;						// eLXgpbg
		BOOL vht;						// OrfI
		BOOL exon;						// vCIeBE
		BOOL hp;						// 
		BOOL bp;						// ŉʃrbgtO
		BOOL gg;						// OtBbN
		BOOL gt;						// eLXg
		BOOL bcon;						// V[v\
		BOOL son;						// XvCgON
		BOOL ton;						// eLXgON
		BOOL gon;						// OtBbNON(1024)
		BOOL gs[4];						// OtBbNON(512)
	} vc_t;

public:
	// {t@NV
	VC(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	DWORD FASTCALL ReadWord(DWORD addr);
										// [hǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	void FASTCALL WriteWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL GetVC(vc_t *buffer);
										// f[^擾
	const BYTE* FASTCALL GetPalette() const	{ return palette; }
										// pbgRAM擾
	const vc_t* FASTCALL GetWorkAddr() const{ return &vc; }
										// [NAhX擾

private:
	// WX^ANZX
	void FASTCALL SetVR0L(DWORD data);
										// WX^0(L)ݒ
	DWORD FASTCALL GetVR0() const;
										// WX^0擾
	void FASTCALL SetVR1H(DWORD data);
										// WX^1(H)ݒ
	void FASTCALL SetVR1L(DWORD data);
										// WX^1(L)ݒ
	DWORD FASTCALL GetVR1() const;
										// WX^1擾
	void FASTCALL SetVR2H(DWORD data);
										// WX^2(H)ݒ
	void FASTCALL SetVR2L(DWORD data);
										// WX^2(L)ݒ
	DWORD FASTCALL GetVR2() const;
										// WX^2擾

	// f[^
	Render *render;
										// _
	vc_t vc;
										// f[^
	BYTE palette[0x400];
										// pbgRAM
};

#endif	// vc_h
