//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ z}V ]
//
//---------------------------------------------------------------------------

#include "os.h"
#include "xm6.h"
#include "config.h"
#include "device.h"
#include "schedule.h"
#include "cpu.h"
#include "memory.h"
#include "sram.h"
#include "sysport.h"
#include "tvram.h"
#include "vc.h"
#include "crtc.h"
#include "rtc.h"
#include "ppi.h"
#include "dmac.h"
#include "mfp.h"
#include "fdc.h"
#include "iosc.h"
#include "sasi.h"
#include "opmif.h"
#include "keyboard.h"
#include "adpcm.h"
#include "gvram.h"
#include "sprite.h"
#include "fdd.h"
#include "scc.h"
#include "mouse.h"
#include "printer.h"
#include "areaset.h"
#include "windrv.h"
#include "render.h"
#include "midi.h"
#include "scsi.h"
#include "mercury.h"
#include "neptune.h"
#include "filepath.h"
#include "fileio.h"
#include "vm.h"

//===========================================================================
//
//	z}V
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
VM::VM()
{
	// [N
	status = FALSE;
	first_device = NULL;
	scheduler = NULL;

	// foCXNULL
	scheduler = NULL;
	cpu = NULL;
	mfp = NULL;
	rtc = NULL;
	sram = NULL;

	// o[W(ۂ̓vbgtH[Đݒ肳)
	major_ver = 0x01;
	minor_ver = 0x00;

	// I̋NJE^XV
	update_boot = TRUE;

	// JgpXNA
	Clear();
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL VM::Init()
{
	Device *device;

	ASSERT(this);
	ASSERT(!first_device);
	ASSERT(!status);

	// dAdXCb`on
	power = TRUE;
	power_sw = TRUE;

	// foCX쐬(ɒ)
	scheduler = new Scheduler(this);
	cpu = new CPU(this);
	new Keyboard(this);
	new Mouse(this);
	new FDD(this);
	new Render(this);
	new Memory(this);
	new GVRAM(this);
	new TVRAM(this);
	new CRTC(this);
	new VC(this);
	new DMAC(this);
	new AreaSet(this);
	mfp = new MFP(this);
	rtc = new RTC(this);
	new Printer(this);
	new SysPort(this);
	new OPMIF(this);
	new ADPCM(this);
	new FDC(this);
	new SASI(this);
	new SCC(this);
	new PPI(this);
	new IOSC(this);
	new Windrv(this);
	new SCSI(this);
	new MIDI(this);
	new Sprite(this);
	new Mercury(this);
	new Neptune(this);
	sram = new SRAM(this);

	// O
	if (!log.Init(this)) {
		return FALSE;
	}

	// foCX|C^
	device = first_device;

	// (Ԃɉ)
	status = TRUE;
	while (device) {
		if (!device->Init()) {
			status = FALSE;
		}
		device = device->GetNextDevice();
	}

	return status;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL VM::Cleanup()
{
	ASSERT(this);

	// dON̏ԂŋIꍇASRAM̋NJE^XV
	if (status) {
		// dONɌ(ʏ́AIOCS̓dOFFōXV邽)
		if (power) {
			// XVtO
			if (update_boot) {
				// SRAMXV
				ASSERT(sram);
				sram->UpdateBoot();
			}
		}
	}

	// |C^͕ύX̂ŁA擪
	while (first_device) {
		first_device->Cleanup();
	}

	// ON[Abv
	log.Cleanup();
}

//---------------------------------------------------------------------------
//
//	Zbg
//
//---------------------------------------------------------------------------
void FASTCALL VM::Reset()
{
	Device *device;

	ASSERT(this);

	// OZbg
	log.Reset();

	// foCX|C^
	device = first_device;

	// Zbg(Ԃɉ)
	while (device) {
		device->Reset();
		device = device->GetNextDevice();
	}

	// JgpXNA
	Clear();
}

//---------------------------------------------------------------------------
//
//	Z[u
//
//---------------------------------------------------------------------------
DWORD FASTCALL VM::Save(const Filepath& path)
{
	Fileio fio;
	char header[0x10];
	int ver;
	Device *device;
	DWORD id;
	DWORD pos;

	ASSERT(this);

	// foCX|C^
	device = first_device;

	// o[W쐬
	ver = (int)((major_ver << 8) | minor_ver);

	// wb_쐬
	sprintf(header, "XM6 DATA %1X.%02X", major_ver, minor_ver);
	header[0x0d] = 0x0d;
	header[0x0e] = 0x0a;
	header[0x0f] = 0x1a;

	// t@C쐬Awb_
	if (!fio.Open(path, Fileio::WriteOnly)) {
		return 0;
	}
	if (!fio.Write(header, 0x10)) {
		fio.Close();
		return 0;
	}

	// Ԃɉ(o[WBCDn)
	while (device) {
		// ID
		id = device->GetID();
		if (!fio.Write(&id, sizeof(id))) {
			fio.Close();
			return 0;
		}

		// foCX
		if (!device->Save(&fio, ver)) {
			// foCXs
			fio.Close();
			return 0;
		}

		// ̃foCX
		device = device->GetNextDevice();
	}

	// ʗpƂāAfoCXEND^
	id = MAKEID('E', 'N', 'D', ' ');
	if (!fio.Write(&id, sizeof(id))) {
		fio.Close();
		return 0;
	}

	// ʒuۑ
	pos = fio.GetFilePos();

	// t@CN[Y
	fio.Close();

	// Jgɐݒ
	current = path;

	// 
	return pos;
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
DWORD FASTCALL VM::Load(const Filepath& path)
{
	Fileio fio;
	char buf[0x10];
	int rec;
	int ver;
	Device *device;
	DWORD id;
	DWORD pos;

	ASSERT(this);

	// JgpXNA
	current.Clear();

	// t@CI[vAwb_ǂݍ
	if (!fio.Open(path, Fileio::ReadOnly)) {
		return 0;
	}
	if (!fio.Read(buf, 0x10)) {
		fio.Close();
		return 0;
	}

	// L^o[W擾
	buf[0x0a] = '\0';
	rec = ::strtoul(&buf[0x09], NULL, 16);
	rec <<= 8;
	buf[0x0d] = '\0';
	rec |= ::strtoul(&buf[0x0b], NULL, 16);

	// so[W쐬
	ver = (int)((major_ver << 8) | minor_ver);

	// wb_`FbN
	buf[0x09] = '\0';
	if (strcmp(buf, "XM6 DATA ") != 0) {
		fio.Close();
		return 0;
	}

	// o[W`FbN
	if (ver < rec) {
		// L^Ăo[ŴقV(mȂ`)
		fio.Close();
		return 0;
	}

	// foCXȂ(o[WBCDn)
	for (;;) {
		// IDǂݍ
		if (!fio.Read(&id, sizeof(id))) {
			fio.Close();
			return 0;
		}

		// I[`FbN
		if (id == MAKEID('E', 'N', 'D', ' ')) {
			break;
		}

		// foCXT[`
		device = SearchDevice(id);
		if (!device) {
			// Z[uɑ݂foCXA͂ȂB[hłȂ
			fio.Close();
			return 0;
		}

		// foCX
		if (!device->Load(&fio, rec)) {
			// foCXs
			fio.Close();
			return 0;
		}
	}

	// ʒuۑ
	pos = fio.GetFilePos();

	// t@CN[Y
	fio.Close();

	// Jgɐݒ
	current = path;

	// 
	return pos;
}

//---------------------------------------------------------------------------
//
//	pX擾
//
//---------------------------------------------------------------------------
void FASTCALL VM::GetPath(Filepath& path) const
{
	ASSERT(this);

	path = current;
}

//---------------------------------------------------------------------------
//
//	pXNA
//
//---------------------------------------------------------------------------
void FASTCALL VM::Clear()
{
	ASSERT(this);

	current.Clear();
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL VM::ApplyCfg(const Config *config)
{
	Device *device;

	ASSERT(this);
	ASSERT(config);

	// VMŗL̐ݒ
	update_boot = config->update_boot;

	// foCX|C^
	device = first_device;

	// Kp(Ԃɉ)
	while (device) {
		device->ApplyCfg(config);
		device = device->GetNextDevice();
	}
}

//---------------------------------------------------------------------------
//
//	foCXǉ
//	ǉDeviceĂяo
//
//---------------------------------------------------------------------------
void FASTCALL VM::AddDevice(Device *device)
{
	Device *dev;

	ASSERT(this);
	ASSERT(device);

	// ŏ̃foCX
	if (!first_device) {
		// ̃foCXŏBo^
		first_device = device;
		ASSERT(!device->GetNextDevice());
		return;
	}

	// I[T
	dev = first_device;
	while (dev->GetNextDevice()) {
		dev = dev->GetNextDevice();
	}

	// dev̌ɒǉ
	dev->SetNextDevice(device);
	ASSERT(!device->GetNextDevice());
}

//---------------------------------------------------------------------------
//
//	foCX폜
//	폜DeviceĂяo
//
//---------------------------------------------------------------------------
void FASTCALL VM::DelDevice(const Device *device)
{
	Device *dev;

	ASSERT(this);
	ASSERT(device);

	// ŏ̃foCX
	if (first_device == device) {
		// ȂAo^BȂNULL
		if (device->GetNextDevice()) {
			first_device = device->GetNextDevice();
		}
		else {
			first_device = NULL;
		}
		return;
	}

	// deviceLĂTuEBhET
	dev = first_device;
	while (dev->GetNextDevice() != device) {
		ASSERT(dev->GetNextDevice());
		dev = dev->GetNextDevice();
	}

	// device->next_deviceAdevɌтXLbv
	dev->SetNextDevice(device->GetNextDevice());
}

//---------------------------------------------------------------------------
//
//	foCX
//	ȂNULLԂ
//
//---------------------------------------------------------------------------
Device* FASTCALL VM::SearchDevice(DWORD id) const
{
	Device *dev;

	ASSERT(this);

	// foCX
	dev = first_device;

	// [v
	while (dev) {
		// IDv邩`FbN
		if (dev->GetID() == id) {
			return dev;
		}

		// 
		dev = dev->GetNextDevice();
	}

	// Ȃ
	return NULL;
}

//---------------------------------------------------------------------------
//
//	s
//
//---------------------------------------------------------------------------
BOOL FASTCALL VM::Exec(DWORD hus)
{
	DWORD ret;

	ASSERT(this);
	ASSERT(scheduler);

	// d`FbN
	if (power) {
		// s[v
		while (hus > 0) {
			ret = scheduler->Exec(hus);

			// ȂAc^C炷
			if (ret < 0x80000000) {
				hus -= ret;
				continue;
			}

			// u[NAFALSEŏI
			return FALSE;
		}
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	g[X
//
//---------------------------------------------------------------------------
void FASTCALL VM::Trace()
{
	ASSERT(this);
	ASSERT(scheduler);

	// d`FbN
	if (!power) {
		return;
	}

	// 0ȊOo܂Ŏs
	for (;;) {
		if (scheduler->Trace(100) != 0) {
			return;
		}
	}
}

//---------------------------------------------------------------------------
//
//	dXCb`
//
//---------------------------------------------------------------------------
void FASTCALL VM::PowerSW(BOOL sw)
{
	ASSERT(this);

	// ݂̏ԂƓȂ牽Ȃ
	if (power_sw == sw) {
		return;
	}

	// L
	power_sw = sw;

	// dItȂAdIŃZbg
	if (sw) {
		SetPower(TRUE);
	}

	// MFPɑ΂Ad`
	ASSERT(mfp);
	if (sw) {
		mfp->SetGPIP(2, 0);
	}
	else {
		mfp->SetGPIP(2, 1);
	}
}

//---------------------------------------------------------------------------
//
//	d̏Ԃݒ
//
//---------------------------------------------------------------------------
void FASTCALL VM::SetPower(BOOL flag)
{
	ASSERT(this);

	// vĂΉȂ
	if (flag == power) {
		return;
	}

	// v
	power = flag;

	if (flag) {
		// dON(AWXgs)
		Reset();
		ASSERT(rtc);
		rtc->Adjust(FALSE);
	}
}

//---------------------------------------------------------------------------
//
//	o[Wݒ
//
//---------------------------------------------------------------------------
void FASTCALL VM::SetVersion(DWORD major, DWORD minor)
{
	ASSERT(this);
	ASSERT(major < 0x100);
	ASSERT(minor < 0x100);

	major_ver = major;
	minor_ver = minor;
}

//---------------------------------------------------------------------------
//
//	o[W擾
//
//---------------------------------------------------------------------------
void FASTCALL VM::GetVersion(DWORD& major, DWORD& minor)
{
	ASSERT(this);
	ASSERT(major_ver < 0x100);
	ASSERT(minor_ver < 0x100);

	major = major_ver;
	minor = minor_ver;
}
