//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ z}V ]
//
//---------------------------------------------------------------------------

#if !defined(vm_h)
#define vm_h

#include "log.h"
#include "schedule.h"
#include "cpu.h"
#include "filepath.h"

//===========================================================================
//
//	z}V
//
//===========================================================================
class VM
{
public:
	// {t@NV
	VM();
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// Xe[gۑ
	DWORD FASTCALL Save(const Filepath& path);
										// Z[u
	DWORD FASTCALL Load(const Filepath& path);
										// [h
	void FASTCALL GetPath(Filepath& path) const;
										// pX擾
	void FASTCALL Clear();
										// pXNA

	// foCXǗ
	void FASTCALL AddDevice(Device *device);
										// foCXǉ(qĂ΂)
	void FASTCALL DelDevice(const Device *device);
										// foCX폜(qĂ΂)
	Device* FASTCALL GetFirstDevice() const	{ return first_device; }
										// ŏ̃foCX擾
	Device* FASTCALL SearchDevice(DWORD id) const;
										// CID̃foCX擾

	// s
	BOOL FASTCALL Exec(DWORD hus);
										// s
	void FASTCALL Trace();
										// g[X
	void FASTCALL Break()				{ scheduler->Break(); }
										// s~

	// o[W
	void FASTCALL SetVersion(DWORD major, DWORD minor);
										// o[Wݒ
	void FASTCALL GetVersion(DWORD& major, DWORD& minor);
										// o[W擾

	// VXe
	void FASTCALL PowerSW(BOOL sw);
										// dXCb`
	BOOL FASTCALL IsPowerSW() const		{ return power_sw; }
										// dXCb`Ԏ擾
	void FASTCALL SetPower(BOOL flag);
										// d
	BOOL FASTCALL IsPower() const		{ return power; }
										// dԎ擾
	void FASTCALL Interrupt() const		{ cpu->Interrupt(7, -1); }
										// NMI荞
	Log log;
										// O

private:
	BOOL status;
										// Xe[^X
	Device *first_device;
										// ŏ̃foCX
	Scheduler *scheduler;
										// XPW[
	CPU *cpu;
										// CPU
	MFP *mfp;
										// MFP
	RTC *rtc;
										// RTC
	SRAM *sram;
										// SRAM
	BOOL power_sw;
										// dXCb`
	BOOL power;
										// d
	DWORD major_ver;
										// W[o[W
	DWORD minor_ver;
										// }Ci[o[W
	Filepath current;
										// Jgf[^
	BOOL update_boot;
										// IɋNJE^CNg
};

#endif	// vm_h
