//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2004 ohD(ytanaka@ipc-tokai.or.jp)
//	Modified (C) 2006 co (cogoodgmail.com)
//	[ Windrv ]
//
//---------------------------------------------------------------------------

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "log.h"
#include "schedule.h"
#include "memory.h"
#include "cpu.h"
#include "config.h"
#include "windrv.h"
#include "mfc_com.h"
#include "mfc_cfg.h"

//===========================================================================
//
//	Human68k
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	pX擾
//
//---------------------------------------------------------------------------
void FASTCALL Human68k::namests_t::GetCopyPath(BYTE* szPath) const
{
	ASSERT(this);
	ASSERT(szPath);
	// WARNING: UnicodeΉvC

	BYTE* p = szPath;
	for (int i = 0; i < 65; i++) {
		BYTE c = path[i];
		if (c == '\0') break;
		if (c == 0x09) {
			c = '/';
		}
		*p++ = c;
	}

	*p = '\0';
}

//---------------------------------------------------------------------------
//
//	t@C擾
//
//	TwentyOneŐGgƓ̃t@CČ\͂B
//
//	zfBNgGg@\ȏꍇ:
//	Human68kŃChJ[hׂ'?'ɓWJĂ܂
//	߁A18 + 3蒷t@Čs\ƂȂB̂悤
//	ꍇ́AChJ[hϊsȂƂŁAFILESɂSt@
//	Č\ƂȂBȂA\ɂȂ邾ŃI[v͂
//	Ȃ̂ŒӁB
//
//	ׂẴt@CI[vꍇ̓fBNgGgLb
//	VLɂ邱ƁBt@CϊsvɂȂfɓ삷B
//
//---------------------------------------------------------------------------
void FASTCALL Human68k::namests_t::GetCopyFilename(BYTE* szFilename) const
{
	ASSERT(this);
	ASSERT(szFilename);
	// WARNING: UnicodeΉvC

	int i;
	BYTE* p = szFilename;
#ifdef XM6_WINDRV_WILDCARD
	BYTE* pWild = NULL;
#endif // XM6_WINDRV_WILDCARD

	// t@C{̓]
	for (i = 0; i < 8; i++) {
		BYTE c = name[i];
		if (c == ' ') {
			BOOL bTerminate = TRUE;
			// t@CɃXy[XoꍇAȍ~̃GgĂ邩ǂmF
			// add[0] LȕȂ瑱
			if (add[0] != '\0') {
				bTerminate = FALSE;
			} else {
				// name[i] ɋ󔒈ȊO݂̕Ȃ瑱
				for (int j = i + 1; j < 8; j++) {
					if (name[j] != ' ') {
						bTerminate = FALSE;
						break;
					}
				}
			}
			// t@CI[Ȃ]I
			if (bTerminate) break;
		}
#ifdef XM6_WINDRV_WILDCARD
		if (c == '?') {
			if (pWild == NULL) pWild = p;
		} else {
			pWild = NULL;
		}
#endif // XM6_WINDRV_WILDCARD
		*p++ = c;
	}
	// SĂ̕ǂݍނƁA i >= 8 ƂȂ

	// t@C{̂8ȏȂǉ
	if (i >= 8) {
		// t@Cǉ]
		for (i = 0; i < 10; i++) {
			BYTE c = add[i];
			if (c == '\0') break;
#ifdef XM6_WINDRV_WILDCARD
			if (c == '?') {
				if (pWild == NULL) pWild = p;
			} else {
				pWild = NULL;
			}
#endif // XM6_WINDRV_WILDCARD
			*p++ = c;
		}
		// SĂ̕ǂݍނƁA i >= 10 ƂȂ
	}

#ifdef XM6_WINDRV_WILDCARD
	// t@CChJ[hŁA㔼10ׂ̂ĂgpĂ邩H
	if (pWild && i >= 10) {
		p = pWild;
		*p++ = '*';
	}
#endif // XM6_WINDRV_WILDCARD

	// t@C{̂͏IAgq̏Jn
#ifdef XM6_WINDRV_WILDCARD
	pWild = NULL;
#endif // XM6_WINDRV_WILDCARD
	i = 0;

	// gq݂邩H
	if (ext[0] == ' ' && ext[1] == ' ' && ext[2] == ' ') {
		// gqȂ
	} else {
		// gq]
		*p++ = '.';
		for (i = 0; i < 3; i++) {
			BYTE c = ext[i];
			if (c == ' ') {
				BOOL bTerminate = TRUE;
				// gqɃXy[XoꍇAȍ~̃GgĂ邩ǂmF
				// ext[i] ɋ󔒈ȊO݂̕Ȃ瑱
				for (int j = i + 1; j < 3; j++) {
					if (ext[j] != ' ') {
						bTerminate = FALSE;
						break;
					}
				}
				// gqI[Ȃ]I
				if (bTerminate) break;
			}
#ifdef XM6_WINDRV_WILDCARD
			if (c == '?') {
				if (pWild == NULL) pWild = p;
			} else {
				pWild = NULL;
			}
#endif // XM6_WINDRV_WILDCARD
			*p++ = c;
		}
		// SĂ̕ǂݍނƁA i >= 3 ƂȂ
	}

#ifdef XM6_WINDRV_WILDCARD
	// gqChJ[hŁAgq3ׂĂgpĂ邩H
	if (pWild && i >= 3) {
		p = pWild;
		*p++ = '*';
	}
#endif // XM6_WINDRV_WILDCARD

	// ԕǉ
	*p = '\0';
}

//===========================================================================
//
//	R}hnh
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CWindrv::CWindrv(Windrv* pWindrv, Memory* pMemory, DWORD nHandle)
{
	windrv = pWindrv;
	memory = pMemory;
	a5 = 0;
	unit = 0;
	command = 0;

	m_nHandle = nHandle;
	m_bAlloc = FALSE;
	m_bExecute = FALSE;
	m_bReady = FALSE;
	m_bTerminate = FALSE;
	m_hThread = NULL;
	m_hEventStart = NULL;
	m_hEventReady = NULL;
}

//---------------------------------------------------------------------------
//
//	fXgN^
//
//---------------------------------------------------------------------------
CWindrv::~CWindrv()
{
	Terminate();
}

//---------------------------------------------------------------------------
//
//	XbhN
//
//---------------------------------------------------------------------------
BOOL FASTCALL CWindrv::Start()
{
	ASSERT(this);
	ASSERT(m_bAlloc == FALSE);
	ASSERT(m_bExecute == FALSE);
	ASSERT(m_bTerminate == FALSE);
	ASSERT(m_hThread == NULL);
	ASSERT(m_hEventStart == NULL);
	ASSERT(m_hEventReady == NULL);

	// nhm
	m_hEventStart = ::CreateEvent(NULL, FALSE, FALSE, NULL);	// Zbg
	ASSERT(m_hEventStart);

	m_hEventReady = ::CreateEvent(NULL, TRUE, FALSE, NULL);	// 蓮Zbg 
	ASSERT(m_hEventReady);

	// Xbh
	DWORD nThread;
	m_hThread = ::CreateThread(NULL, 0, Run, this, 0, &nThread);
	ASSERT(m_hThread);

	// G[`FbN
	if (m_hEventStart == NULL ||
		m_hEventReady == NULL ||
		m_hThread == NULL) return FALSE;

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	Xbh~
//
//---------------------------------------------------------------------------
BOOL FASTCALL CWindrv::Terminate()
{
	ASSERT(this);

	BOOL bResult = TRUE;

	if (m_hThread) {
		ASSERT(m_bTerminate == FALSE);
		ASSERT(m_hEventStart);

		// Xbh֒~v
		m_bTerminate = TRUE;
		::SetEvent(m_hEventStart);

		// XbhI҂
		DWORD nResult;
		nResult = ::WaitForSingleObject(m_hThread, 30 * 1000);	// P\ 30b
		if (nResult != WAIT_OBJECT_0) {
			// ~
			ASSERT(FALSE);	// Ô
			::TerminateThread(m_hThread, -1);
			nResult = ::WaitForSingleObject(m_hThread, 100);
			bResult = FALSE;
		}

		// XbhnhJ
		::CloseHandle(m_hThread);
		m_hThread = NULL;

		// ~v艺
		m_bTerminate = FALSE;
	}

	// CxgnhJ
	if (m_hEventStart) {
		::CloseHandle(m_hEventStart);
		m_hEventStart = NULL;
	}

	if (m_hEventReady) {
		::CloseHandle(m_hEventReady);
		m_hEventReady = NULL;
	}

	// ̂܂ܓIuWFNgŃXbhNł悤
	m_bAlloc = FALSE;
	m_bExecute = FALSE;
	m_bReady = FALSE;
	m_bTerminate = FALSE;

	return bResult;
}

//---------------------------------------------------------------------------
//
//	R}hs
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Execute(DWORD nA5)
{
	ASSERT(this);
	ASSERT(m_bExecute == FALSE);
	ASSERT(m_bTerminate == FALSE);
	ASSERT(m_hThread);
	ASSERT(m_hEventStart);
	ASSERT(m_hEventReady);
	ASSERT(nA5 <= 0xFFFFFF);

	// sJntOZbg
	m_bExecute = TRUE;

	// NGXgwb_̃AhX
	a5 = nA5;

	// G[NA
	SetByte(a5 + 3, 0);
	SetByte(a5 + 4, 0);

	// jbgԍl
	unit = GetByte(a5 + 1);

	// R}hl
	command = GetByte(a5 + 2);

	// Xbhҋ@
	m_bReady = FALSE;
	::ResetEvent(m_hEventReady);

	// sJnCxgZbg
	::SetEvent(m_hEventStart);

	// }`XbhJnv܂ł͎VOXbhƂĐU镑
	DWORD nResult = ::WaitForSingleObject(m_hEventReady, INFINITE);
	ASSERT(nResult == WAIT_OBJECT_0);	// Ô
}

#ifdef WINDRV_SUPPORT_COMPATIBLE
//---------------------------------------------------------------------------
//
//	R}hs (WINDRV݊)
//
//---------------------------------------------------------------------------
DWORD FASTCALL CWindrv::ExecuteCompatible(DWORD nA5)
{
	ASSERT(this);
	ASSERT(nA5 <= 0xFFFFFF);

	// NGXgwb_̃AhX
	a5 = nA5;

	// G[NA
	SetByte(a5 + 3, 0);
	SetByte(a5 + 4, 0);

	// jbgԍl
	unit = GetByte(a5 + 1);

	// R}hl
	command = GetByte(a5 + 2);

	// R}hs
	ExecuteCommand();

	return GetByte(a5 + 3) | (GetByte(a5 + 4) << 8);
}
#endif // WINDRV_SUPPORT_COMPATIBLE

//---------------------------------------------------------------------------
//
//	R}h҂VMXbhsĊJ
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Ready()
{
	ASSERT(this);
	ASSERT(m_hEventReady);

	m_bReady = TRUE;
	::SetEvent(m_hEventReady);
}

//---------------------------------------------------------------------------
//
//	XbhsJn|Cg
//
//---------------------------------------------------------------------------
DWORD WINAPI CWindrv::Run(VOID* pThis)
{
	ASSERT(pThis);

	((CWindrv*)pThis)->Runner();

	::ExitThread(0);
	return 0;
}

//---------------------------------------------------------------------------
//
//	Xbh
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Runner()
{
	ASSERT(this);
	ASSERT(m_hEventStart);
	ASSERT(m_hEventReady);
	//ASSERT(m_bTerminate == FALSE);
	// XbhJnɂȂTerminateƁA̎_ m_bTerminate 
	// TRUEƂȂ\BԌo߂ɂďIAȈuԂɓ
	// 邽ASSERTȂłȂB

	for (;;) {
		DWORD nResult = ::WaitForSingleObject(m_hEventStart, INFINITE);
		if (nResult != WAIT_OBJECT_0) {
			ASSERT(FALSE);	// Ô
			break;
		}
		if (m_bTerminate) break;

		// s
		ExecuteCommand();

		// sIOɒʒm
		Ready();

		// s
		m_bExecute = FALSE;
	}

	Ready();	// Ô
}

//===========================================================================
//
//	R}hnhǗ
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	
//
//	SXbhmۂAҋ@ԂɂB
//
//---------------------------------------------------------------------------
void FASTCALL CWindrvManager::Init(Windrv* pWindrv, Memory* pMemory)
{
	ASSERT(this);
	ASSERT(pWindrv);
	ASSERT(pMemory);

	for (int i = 0; i < WINDRV_THREAD_MAX; i++) {
		m_pThread[i] = new CWindrv(pWindrv, pMemory, i);
		m_pThread[i]->Start();
	}
}

//---------------------------------------------------------------------------
//
//	I
//
//	SẴXbh~B
//
//---------------------------------------------------------------------------
void FASTCALL CWindrvManager::Clean()
{
	ASSERT(this);

	for (int i = 0; i < WINDRV_THREAD_MAX; i++) {
		ASSERT(m_pThread[i]);	// Ô
		delete m_pThread[i];
		m_pThread[i] = NULL;
	}
}

//---------------------------------------------------------------------------
//
//	Zbg
//
//	s̃XbĥݍċNB
//
//---------------------------------------------------------------------------
void FASTCALL CWindrvManager::Reset()
{
	ASSERT(this);

	for (int i = 0; i < WINDRV_THREAD_MAX; i++) {
		ASSERT(m_pThread[i]);	// Ô
		if (m_pThread[i]->isAlloc()) {
			m_pThread[i]->Terminate();
			m_pThread[i]->Start();
		}
	}
}

//---------------------------------------------------------------------------
//
//	󂫃Xbhm
//
//---------------------------------------------------------------------------
CWindrv* FASTCALL CWindrvManager::Alloc()
{
	ASSERT(this);

	for (int i = 0; i < WINDRV_THREAD_MAX; i++) {
		if (m_pThread[i]->isAlloc() == FALSE) {
			m_pThread[i]->SetAlloc(TRUE);
			return m_pThread[i];
		}
	}

	return NULL;
}

//---------------------------------------------------------------------------
//
//	Xbh
//
//---------------------------------------------------------------------------
CWindrv* FASTCALL CWindrvManager::Search(DWORD nHandle)
{
	ASSERT(this);

	if (nHandle >= WINDRV_THREAD_MAX) return NULL;
	return m_pThread[nHandle];
}

//---------------------------------------------------------------------------
//
//	XbhJ
//
//---------------------------------------------------------------------------
void FASTCALL CWindrvManager::Free(CWindrv* p)
{
	ASSERT(this);
	ASSERT(p);

	p->SetAlloc(FALSE);
}

//===========================================================================
//
//	Windrv
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
Windrv::Windrv(VM *p) : MemDevice(p)
{
	// foCXID
	dev.id = MAKEID('W', 'D', 'R', 'V');
	dev.desc = "Windrv";

	// JnAhXAIAhX
	memdev.first = 0xe9e000;
	memdev.last = 0xe9ffff;
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL Windrv::Init()
{
	ASSERT(this);

	// {NX
	if (!MemDevice::Init()) {
		return FALSE;
	}

	// O[otO
	windrv.enable = WINDRV_MODE_NONE;

	// hCu0At@CVXe
	windrv.drives = 0;
	windrv.fs = NULL;

	// Xbh
	Memory* memory = (Memory*)vm->SearchDevice(MAKEID('M', 'E', 'M', ' '));
	ASSERT(memory);
	m_cThread.Init(this, memory);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL Windrv::Cleanup()
{
	ASSERT(this);

	// XbhSJ
	m_cThread.Clean();

	// t@CVXe΁AZbg
	if (windrv.fs) {
		windrv.fs->Reset();
	}

	// {NX
	MemDevice::Cleanup();
}

//---------------------------------------------------------------------------
//
//	Zbg
//
//---------------------------------------------------------------------------
void FASTCALL Windrv::Reset()
{
	ASSERT(this);

	LOG(Log::Normal, "Zbg");

	// Xbhsł΁AZbg
	m_cThread.Reset();

	// t@CVXe΁AZbg
	if (windrv.fs) {
		windrv.fs->Reset();
	}

	// hCu
	windrv.drives = 0;
}

//---------------------------------------------------------------------------
//
//	Z[u
//
//---------------------------------------------------------------------------
BOOL FASTCALL Windrv::Save(Fileio *fio, int ver)
{
	ASSERT(this);
	LOG(Log::Normal, "Z[u");

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
BOOL FASTCALL Windrv::Load(Fileio *fio, int ver)
{
	ASSERT(this);
	LOG(Log::Normal, "[h");

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL Windrv::ApplyCfg(const Config* pConfig)
{
	ASSERT(this);
	ASSERT(pConfig);
	LOG(Log::Normal, "ݒKp");

	// tOݒ
	windrv.enable = pConfig->windrv_enable;
}

//---------------------------------------------------------------------------
//
//	oCgǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL Windrv::ReadByte(DWORD addr)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));

	// |[g1
	if (addr == 0xE9F001) {
		return StatusAsynchronous();
	}

	DWORD result = ReadOnly(addr);

#ifdef WINDRV_LOG
	switch (result) {
	case 'X':
		LOG(Log::Normal, "Windrv|[g T|[g");
		break;
	case 'Y':
		LOG(Log::Normal, "Windrv|[g p\");
		break;
#ifdef WINDRV_SUPPORT_COMPATIBLE
	case 'W':
		LOG(Log::Normal, "Windrv|[g ݊");
		break;
#endif // WINDRV_SUPPORT_COMPATIBLE
	}
#endif // WINDRV_LOG

	if (result == 0xFF) {
		cpu->BusErr(addr, TRUE);
	}

	return result;
}

//---------------------------------------------------------------------------
//
//	ǂݍ݂̂
//
//---------------------------------------------------------------------------
DWORD FASTCALL Windrv::ReadOnly(DWORD addr) const
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));

	// ʃ|[gȊO-1
	if (addr != 0xE9F000) {
		return 0xFF;
	}

	switch (windrv.enable) {
	case WINDRV_MODE_DUAL:
	case WINDRV_MODE_ENABLE:
		return 'Y';			// WindrvXM

	case WINDRV_MODE_COMPATIBLE:
#ifdef WINDRV_SUPPORT_COMPATIBLE
		return 'W';			// WINDRV݊
#endif // WINDRV_SUPPORT_COMPATIBLE

	case WINDRV_MODE_NONE:
		return 'X';			// gps (I/OԂ݂͑)
	}

	// I/OԂ݂Ȃꍇ-1
	return 0xFF;
}

//---------------------------------------------------------------------------
//
//	oCg
//
//	windrv|[gւ̏݌Ad0.wŃUgʒmB
//
//	8bit͎̒ʂB
//		$1x	G[(~̂)
//		$2x	G[(Ďŝ)
//		$3x	G[(Ďs~)
//		$4x	G[(̂)
//		$5x	G[(~)
//		$6x	G[(Ďs)
//		$7x	G[(Ďs~)
//	8bit͎̒ʂB
//		$01	ȃjbgԍw肵.
//		$02	fBXNĂȂ.
//		$03	foCXhCoɖȃR}hw肵.
//		$04	CRC G[.
//		$05	fBXN̊Ǘ̈悪j󂳂Ă.
//		$06	V[NG[.
//		$07	ȃfBA.
//		$08	ZN^Ȃ.
//		$09	v^qĂȂ.
//		$0a	݃G[.
//		$0b	ǂݍ݃G[.
//		$0c	̑̃G[.
//		$0d	CgveNg(veNgOēfBXN).
//		$0e	ݕs\.
//		$0f	t@CLᔽ.
//
//---------------------------------------------------------------------------
void FASTCALL Windrv::WriteByte(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT((addr >= memdev.first) && (addr <= memdev.last));

	// T|[ĝ݃|[g
	switch (windrv.enable) {
	case WINDRV_MODE_DUAL:
	case WINDRV_MODE_ENABLE:
		switch (addr) {
		case 0xE9F000:
#ifdef WINDRV_SUPPORT_COMPATIBLE
			if (windrv.enable == WINDRV_MODE_DUAL) {
				Execute();	// \Ȃ炱łc
			}
#endif // WINDRV_SUPPORT_COMPATIBLE
			return;		// |[głoXG[ɂȂ(dv)
		case 0xE9F001:
			switch (data) {
			case 0x00: ExecuteAsynchronous(); return;
			case 0xFF: ReleaseAsynchronous(); return;
			}
			return;		// sȒl݂̏łoXG[ɂȂ(gp)
		}
		break;

	case WINDRV_MODE_COMPATIBLE:
#ifdef WINDRV_SUPPORT_COMPATIBLE
		switch (addr) {
		case 0xE9F000:
			Execute();
			return;
		}
		break;
#endif // WINDRV_SUPPORT_COMPATIBLE

	case WINDRV_MODE_NONE:
		switch (addr) {
		case 0xE9F000:
		case 0xE9F001:
			return;		// |[gAhX̂ݎ (o[WXM6Ƃ̌݊̂)
		}
		break;
	}

	// ݐ悪Ȃ΃oXG[
	cpu->BusErr(addr, FALSE);
	return;
}

#ifdef WINDRV_SUPPORT_COMPATIBLE
//---------------------------------------------------------------------------
//
//	R}hnh
//
//---------------------------------------------------------------------------
void FASTCALL Windrv::Execute()
{
	ASSERT(this);

	// NGXgwb_󂯎
	CPU::cpu_t reg;
	cpu->GetCPU(&reg);
	DWORD a5 = reg.areg[5];
	ASSERT(a5 <= 0xFFFFFF);

	// s
	CWindrv* ps = m_cThread.Alloc();
	ASSERT(ps);
	DWORD result = ps->ExecuteCompatible(a5);
	m_cThread.Free(ps);

	// WINDRV݊̂D0.Lݒ
	reg.dreg[0] = result;
	cpu->SetCPU(&reg);

	// ^͑SẴR}h128us
	scheduler->Wait(128);	// TODO: mȒlZo
}
#endif // WINDRV_SUPPORT_COMPATIBLE

//---------------------------------------------------------------------------
//
//	R}hsJn 񓯊
//
//---------------------------------------------------------------------------
void FASTCALL Windrv::ExecuteAsynchronous()
{
	ASSERT(this);

	// NGXgwb_󂯎
	CPU::cpu_t reg;
	cpu->GetCPU(&reg);
	DWORD a5 = reg.areg[5];
	ASSERT(a5 <= 0xFFFFFF);

	// 󂫃Xbh{
	CWindrv* thread = m_cThread.Alloc();
	if (thread) {
		// XbhsJn
		thread->Execute(a5);
		reg.dreg[0] = thread->GetHandle();
	} else {
		// XbhȂ-1
		reg.dreg[0] = (DWORD)-1;
		::Sleep(0);		// Xbhsuڂ
	}

	// nhZbgđI
	cpu->SetCPU(&reg);
}

//---------------------------------------------------------------------------
//
//	Xe[^Xl 񓯊
//
//---------------------------------------------------------------------------
DWORD FASTCALL Windrv::StatusAsynchronous()
{
	ASSERT(this);

	// nh󂯎
	CPU::cpu_t reg;
	cpu->GetCPU(&reg);
	DWORD handle = reg.dreg[0];

	// Ynh̃Xe[^Xl
	CWindrv* thread = m_cThread.Search(handle);
	if (thread) {
		if (thread->isExecute()) {
			::Sleep(0);		// Xbhsuڂ
			return 0;		// ܂sȂ0
		}

		return 1;			// sȂ1
	}

	return 0xFF;			// sȃnhȂ-1
}

//---------------------------------------------------------------------------
//
//	nhJ 񓯊
//
//---------------------------------------------------------------------------
void FASTCALL Windrv::ReleaseAsynchronous()
{
	ASSERT(this);

	// D0.L(nh)󂯎
	CPU::cpu_t reg;
	cpu->GetCPU(&reg);
	DWORD handle = reg.dreg[0];

	// YnhJ
	CWindrv* thread = m_cThread.Search(handle);
	if (thread) {
		m_cThread.Free(thread);
	}
}

//---------------------------------------------------------------------------
//
//	R}hs
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::ExecuteCommand()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);

	if (command == 0x40) {
		// $40 - 
		InitDrive();
		return;
	}

	if (windrv->isInvalidUnit(unit)) {
		LockXM();

		// ȃjbgԍw肵
		SetResult(FS_FATAL_INVALIDUNIT);

		UnlockXM();
		return;
	}

	// R}h
	switch (command & 0x7F) {
		case 0x41: CheckDir(); return;		// $41 - fBNg`FbN
		case 0x42: MakeDir(); return;		// $42 - fBNg쐬
		case 0x43: RemoveDir(); return;		// $43 - fBNg폜
		case 0x44: Rename(); return;		// $44 - t@CύX
		case 0x45: Delete(); return;		// $45 - t@C폜
		case 0x46: Attribute(); return;		// $46 - t@C擾/ݒ
		case 0x47: Files(); return;			// $47 - t@C(First)
		case 0x48: NFiles(); return;		// $48 - t@C(Next);
		case 0x49: Create(); return;		// $49 - t@C쐬
		case 0x4A: Open(); return;			// $4A - t@CI[v
		case 0x4B: Close(); return;			// $4B - t@CN[Y
		case 0x4C: Read(); return;			// $4C - t@Cǂݍ
		case 0x4D: Write(); return;			// $4D - t@C
		case 0x4E: Seek(); return;			// $4E - t@CV[N
		case 0x4F: TimeStamp(); return;		// $4F - t@CXV̎擾/ݒ
		case 0x50: GetCapacity(); return;	// $50 - eʎ擾
		case 0x51: CtrlDrive(); return;		// $51 - hCu/Ԍ
		case 0x52: GetDPB(); return;		// $52 - DPB擾
		case 0x53: DiskRead(); return;		// $53 - ZN^ǂݍ
		case 0x54: DiskWrite(); return;		// $54 - ZN^
		case 0x55: IoControl(); return;		// $55 - IOCTRL
		case 0x56: Flush(); return;			// $56 - tbV
		case 0x57: CheckMedia(); return;	// $57 - fBA`FbN
		case 0x58: Lock(); return;			// $58 - r
	}


	LockXM();

	// foCXhCoɖȃR}hw肵
	SetResult(FS_FATAL_INVALIDCOMMAND);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	t@CVXeݒ
//
//---------------------------------------------------------------------------
void FASTCALL Windrv::SetFileSys(FileSys *fs)
{
	ASSERT(this);

	// ݑ݂ꍇAvȂΈU
	if (windrv.fs) {
		if (windrv.fs != fs) {
			// 
			Reset();
		}
	}

	// NULL܂͎
	windrv.fs = fs;
}

//---------------------------------------------------------------------------
//
//	t@CVXeݒ
//
//---------------------------------------------------------------------------
BOOL FASTCALL Windrv::isInvalidUnit(DWORD unit) const
{
	ASSERT(this);

	if (unit >= windrv.drives) return TRUE;	// E傫Εsȃjbgԍ

	ASSERT(windrv.fs);
	// ɂȂAΏۂƂȂFileSys̓샂[h₢킹ׂA
	// ANZXs\ȃt@CVXe͂o^Ȃ̂Ń`FbNsv
	return FALSE;
}

//---------------------------------------------------------------------------
//
//	$40 - 
//
//	in	(offset	size)
//		 0	1.b	萔(22)
//		 2	1.b	R}h($40/$c0)
//		18	1.l	p[^AhX
//		22	1.b	hCuԍ
//	out	(offset	size)
//		 3	1.b	G[R[h()
//		 4	1.b	V	    ()
//		13	1.b	jbg
//		14	1.l	foCXhCȍIAhX + 1
//
//	@[JhCũR}h 0 ƓlɑgݍݎɌĂ΂邪ABPB y
//	т̃|C^̔zpӂKv͂Ȃ.
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::InitDrive()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->GetFilesystem());

#ifdef WINDRV_LOG
	Log(Log::Normal, "$40 - ");
#endif // WINDRV_LOG

	LockXM();

	// x[XhCul
	DWORD base = GetByte(a5 + 22);
	ASSERT(base < 26);
	// DRIVER}hŏςƒlɂȂ邽߁Awindrv.base͔p~

	// IvVel
	BYTE chOption[256];
	GetParameter(GetAddr(a5 + 18), chOption, sizeof(chOption));

	UnlockXM();

	// Human68kŗp\ȃhCu͈̔͂ŁAt@CVXe\z
	DWORD max_unit = windrv->GetFilesystem()->Init(this, 26 - base, chOption);

	// ۂɊmۂꂽjbgۑ
	windrv->SetUnitMax(max_unit);

#ifdef WINDRV_LOG
	Log(Log::Detail, "x[XhCu:%c T|[ghCu:%d",
					'A' + base, max_unit);
#endif // WINDRV_LOG

	LockXM();

	// hCuԐM
	SetByte(a5 + 13, max_unit);

	// Il
	SetResult(0);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$41 - fBNg`FbN
//
//	in
//		14	1.L	NAMESTS\̃AhX
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::CheckDir()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// Ώۃt@Cl
	Human68k::namests_t ns;
	GetNameStsPath(GetAddr(a5 + 14), &ns);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$41 %d fBNg`FbN", unit);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	DWORD nResult = windrv->GetFilesystem()->CheckDir(this, &ns);

	LockXM();

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$42 - fBNg쐬
//
//	in
//		14	1.L	NAMESTS\̃AhX
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::MakeDir()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// Ώۃt@Cl
	Human68k::namests_t ns;
	GetNameSts(GetAddr(a5 + 14), &ns);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$42 %d fBNg쐬", unit);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	DWORD nResult = windrv->GetFilesystem()->MakeDir(this, &ns);

	LockXM();

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$43 - fBNg폜
//
//	in
//		14	1.L	NAMESTS\̃AhX
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::RemoveDir()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// Ώۃt@Cl
	Human68k::namests_t ns;
	GetNameSts(GetAddr(a5 + 14), &ns);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$43 %d fBNg폜", unit);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	DWORD nResult = windrv->GetFilesystem()->RemoveDir(this, &ns);

	LockXM();

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$44 - t@CύX
//
//	in
//		14	1.L	NAMESTS\̃AhX t@C
//		18	1.L	NAMESTS\̃AhX Vt@C
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Rename()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// Ώۃt@Cl
	Human68k::namests_t ns;
	GetNameSts(GetAddr(a5 + 14), &ns);
	Human68k::namests_t ns_new;
	GetNameSts(GetAddr(a5 + 18), &ns_new);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$44 %d t@CύX", unit);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	DWORD nResult = windrv->GetFilesystem()->Rename(this, &ns, &ns_new);

	LockXM();

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$45 - t@C폜
//
//	in
//		14	1.L	NAMESTS\̃AhX
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Delete()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// Ώۃt@Cl
	Human68k::namests_t ns;
	GetNameSts(GetAddr(a5 + 14), &ns);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$45 %d t@C폜", unit);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	DWORD nResult = windrv->GetFilesystem()->Delete(this, &ns);

	LockXM();

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$46 - t@C擾/ݒ
//
//	in
//		12	1.B	ǂݏo0x01ɂȂ̂Œ
//		13	1.B	 $FFƓǂݏo
//		14	1.L	NAMESTS\̃AhX
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Attribute()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// Ώۃt@Cl
	Human68k::namests_t ns;
	GetNameSts(GetAddr(a5 + 14), &ns);

	// Ώۑ
	DWORD attr = GetByte(a5 + 13);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$46 %d t@C擾/ݒ :%02X", unit, attr);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	DWORD nResult = windrv->GetFilesystem()->Attribute(this, &ns, attr);

	LockXM();

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$47 - t@C(First)
//
//	in	(offset	size)
//		 0	1.b	萔(26)
//		 1	1.b	jbgԍ
//		 2	1.b	R}h($47/$c7)
//		13	1.b	
//		14	1.l	t@Cobt@(namests `)
//		18	1.l	obt@(files `) ̃obt@Ɍrƌʂ
//	out	(offset	size)
//		 3	1.b	G[R[h()
//		 4	1.b	V	    ()
//		18	1.l	UgXe[^X
//
//	@fBNgwt@C. DOS _FILES Ăяo.
//	@ɎsꍇAႵ͌ɐĂChJ[hg
//	Ȃꍇ́A񌟍ɕKsׂɌobt@̃ItZbg
//	-1 . ꍇ͌t@C̏ݒ肷
//	ƋɁAp̏̃ZN^ԍAItZbgA[gfBNg̏
//	͍XɎcZN^ݒ肷. hCuEApX DOS R[
//	Őݒ肳̂ŏޕKv͂Ȃ.
//
//	<NAMESTS\>
//	offset	size
//	0	1.b	NAMWLD	0:ChJ[hȂ -1:t@CwȂ
//				(ChJ[h̕)
//	1	1.b	NAMDRV	hCuԍ(A=0,B=1,c,Z=25)
//	2	65.b	NAMPTH	pX('\'{΃TufBNg{'\')
//	67	8.b	NAMNM1	t@C(擪 8 )
//	75	3.b	NAMEXT	gq
//	78	10.b	NAMNM2	t@C(c 10 )
//
// pX؂蕶0x2F(/)0x5C(\)ł͂Ȃ0x09(TAB)gĂ̂Œ
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Files()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// roߊi[̈
	DWORD nFiles = GetAddr(a5 + 18);
	Human68k::files_t info;
	GetFiles(nFiles, &info);
	//info.fatr =  (BYTE)GetByte(a5 + 13);	// ۑ(ɏ܂Ă)

	// Ώۃt@Cl
	Human68k::namests_t ns;
	GetNameSts(GetAddr(a5 + 14), &ns);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$47 %d t@C(First) Info:%X :%02X", unit, nFiles, info.fatr);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	int nResult = windrv->GetFilesystem()->Files(this, &ns, nFiles, &info);

	LockXM();

	// ʂ̔f
	if (nResult >= 0) {
		SetFiles(nFiles, &info);
	}

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$48 - t@C(Next)
//
//	in
//		18	1.L	FILES\̃AhX
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::NFiles()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// [N̈̓ǂݍ
	DWORD nFiles = GetAddr(a5 + 18);
	Human68k::files_t info;
	GetFiles(nFiles, &info);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$48 - t@C(Next) Info:%X", nFiles);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	int nResult = windrv->GetFilesystem()->NFiles(this, nFiles, &info);

	LockXM();

	// ʂ̔f
	if (nResult >= 0) {
		SetFiles(nFiles, &info);
	}

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$49 - t@C쐬(Create)
//
//	in
//		 1	1.B	jbgԍ
//		13	1.B	
//		14	1.L	NAMESTS\̃AhX
//		18	1.L	[h (0:_NEWFILE 1:_CREATE)
//		22	1.L	FCB\̃AhX
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Create()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// Ώۃt@Cl
	Human68k::namests_t ns;
	GetNameSts(GetAddr(a5 + 14), &ns);

	// FCBl
	DWORD nFcb = GetAddr(a5 + 22);	// FCBAhXۑ
	Human68k::fcb_t fcb;
	GetFcb(nFcb, &fcb);

	// 
	DWORD attr = GetByte(a5 + 13);

	// ㏑[h
	BOOL force = (BOOL)GetLong(a5 + 18);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$49 %d t@C쐬 FCB:%X :%02X Mode:%d", unit, nFcb, attr, force);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	int nResult = windrv->GetFilesystem()->Create(this, &ns, nFcb, &fcb, attr, force);

	LockXM();

	// ʂ̔f
	if (nResult >= 0) {
		SetFcb(nFcb, &fcb);
	}

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$4A - t@CI[v
//
//	in
//		 1	1.B	jbgԍ
//		14	1.L	NAMESTS\̃AhX
//		22	1.L	FCB\̃AhX
//				FCBɂ͂قƂǂ̃p[^ݒς
//				Et̓I[vuԂ̂̂ɂȂĂ̂ŏ㏑
//				TCY0ɂȂĂ̂ŏ㏑
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Open()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// Ώۃt@Cl
	Human68k::namests_t ns;
	GetNameSts(GetAddr(a5 + 14), &ns);

	// FCBl
	DWORD nFcb = GetAddr(a5 + 22);	// FCBAhXۑ
	Human68k::fcb_t fcb;
	GetFcb(nFcb, &fcb);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$4A %d t@CI[v FCB:%X Mode:%X", unit, nFcb, fcb.mode);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	int nResult = windrv->GetFilesystem()->Open(this, &ns, nFcb, &fcb);

	LockXM();

	// ʂ̔f
	if (nResult >= 0) {
		SetFcb(nFcb, &fcb);
	}

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$4B - t@CN[Y
//
//	in
//		22	1.L	FCB\̃AhX
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Close()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// FCBl
	DWORD nFcb = GetAddr(a5 + 22);	// FCBAhXۑ
	Human68k::fcb_t fcb;
	GetFcb(nFcb, &fcb);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$4B - t@CN[Y FCB:%X", nFcb);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	DWORD nResult = windrv->GetFilesystem()->Close(this, nFcb, &fcb);

	LockXM();

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$4C - t@Cǂݍ
//
//	in
//		14	1.L	ǂݍ݃obt@ Ƀt@Ceǂݍ
//		18	1.L	TCY ̐Ȃt@CTCYw肵̂Ɠ
//		22	1.L	FCB\̃AhX
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Read()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// FCBl
	DWORD nFcb = GetAddr(a5 + 22);	// FCBAhXۑ
	Human68k::fcb_t fcb;
	GetFcb(nFcb, &fcb);

	// ǂݍ݃obt@
	DWORD nAddress = GetAddr(a5 + 14);

	// ǂݍ݃TCY
	DWORD nSize = GetLong(a5 + 18);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$4C - t@Cǂݍ FCB:%X AhX:%X TCY:%d", nFcb, nAddress, nSize);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	int nResult = windrv->GetFilesystem()->Read(this, nFcb, &fcb, nAddress, nSize);

	LockXM();

	// ʂ̔f
	if (nResult >= 0) {
		SetFcb(nFcb, &fcb);
	}

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$4D - t@C
//
//	in
//		14	1.L	݃obt@ Ƀt@Ce
//		18	1.L	TCY ̐Ȃt@CTCYw肵̂Ɠ
//		22	1.L	FCB\̃AhX
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Write()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// FCBl
	DWORD nFcb = GetAddr(a5 + 22);	// FCBAhXۑ
	Human68k::fcb_t fcb;
	GetFcb(nFcb, &fcb);

	// ݃obt@
	DWORD nAddress = GetAddr(a5 + 14);

	// ݃TCY
	DWORD nSize = GetLong(a5 + 18);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$4D - t@C FCB:%X AhX:%X TCY:%d", nFcb, nAddress, nSize);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	int nResult = windrv->GetFilesystem()->Write(this, nFcb, &fcb, nAddress, nSize);

	LockXM();

	// ʂ̔f
	if (nResult >= 0) {
		SetFcb(nFcb, &fcb);
	}

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$4E - t@CV[N
//
//	in
//		12	1.B	0x2B ɂȂĂƂ 0̂Ƃ
//		13	1.B	[h
//		18	1.L	ItZbg
//		22	1.L	FCB\̃AhX
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Seek()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// FCBl
	DWORD nFcb = GetAddr(a5 + 22);	// FCBAhXۑ
	Human68k::fcb_t fcb;
	GetFcb(nFcb, &fcb);

	// V[N[h
	DWORD nMode = GetByte(a5 + 13);

	// V[NItZbg
	DWORD nOffset = GetLong(a5 + 18);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$4E - t@CV[N FCB:%X [h:%d ItZbg:%d", nFcb, nMode, nOffset);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	int nResult = windrv->GetFilesystem()->Seek(this, nFcb, &fcb, nMode, nOffset);

	LockXM();

	// ʂ̔f
	if (nResult >= 0) {
		SetFcb(nFcb, &fcb);
	}

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$4F - t@C擾/ݒ
//
//	in
//		18	1.W	DATE
//		20	1.W	TIME
//		22	1.L	FCB\̃AhX
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::TimeStamp()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// FCBl
	DWORD nFcb = GetAddr(a5 + 22);	// FCBAhXۑ
	Human68k::fcb_t fcb;
	GetFcb(nFcb, &fcb);

	// l
	WORD nFatDate = (WORD)GetWord(a5 + 18);
	WORD nFatTime = (WORD)GetWord(a5 + 20);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$4F - t@C擾/ݒ FCB:%X :%04X%04X", nFcb, nFatDate, nFatTime);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	DWORD nResult = windrv->GetFilesystem()->TimeStamp(this, nFcb, &fcb, nFatDate, nFatTime);

	LockXM();

	// ʂ̔f
	if ((nResult >> 16) != 0xFFFF) {
		SetFcb(nFcb, &fcb);
	}

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$50 - eʎ擾
//
//	in	(offset	size)
//		 0	1.b	萔(26)
//		 1	1.b	jbgԍ
//		 2	1.b	R}h($50/$d0)
//		14	1.l	obt@AhX
//	out	(offset	size)
//		 3	1.b	G[R[h()
//		 4	1.b	V	    ()
//		18	1.l	UgXe[^X
//
//	@fBȂe/󂫗eʁANX^/ZN^TCY. obt@
//	ɏޓe͈ȉ̒ʂ. UgXe[^XƂĎgp\ȃoCg
//	Ԃ.
//
//	offset	size
//	0	1.w	gp\ȃNX^
//	2	1.w	NX^
//	4	1.w	1 NX^̃ZN^
//	6	1.w	1 ZN^̃oCg
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::GetCapacity()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

#ifdef WINDRV_LOG
	Log(Log::Normal, "$50 %d eʎ擾", unit);
#endif // WINDRV_LOG

	LockXM();

	// obt@擾
	DWORD nCapacity = GetAddr(a5 + 14);
	Human68k::capacity_t cap;
	//GetCapacity(nCapacity, &cap);	// 擾͕sv sv oOv p

	UnlockXM();

	// t@CVXeĂяo
	int nResult = windrv->GetFilesystem()->GetCapacity(this, &cap);

	LockXM();

	// ʂ̔f
	if (nResult >= 0) {
		SetCapacity(nCapacity, &cap);
	}

	// Il
	SetResult(nResult);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Detail, "jbg%d 󂫗e %d", unit, nResult);
#endif // WINDRV_LOG
}

//---------------------------------------------------------------------------
//
//	$51 - hCuԌ/
//
//	in	(offset	size)
//		 1	1.B	jbgԍ
//		13	1.B		0: Ԍ 1: CWFNg
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::CtrlDrive()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// hCuԎ擾
	Human68k::ctrldrive_t ctrl;
	ctrl.status = (BYTE)GetByte(a5 + 13);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$51 %d hCuԌ/ Mode:%d", unit, ctrl.status);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	int nResult = windrv->GetFilesystem()->CtrlDrive(this, &ctrl);

	LockXM();

	// ʂ̔f
	if (nResult >= 0) {
		SetByte(a5 + 13, ctrl.status);
	}

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$52 - DPB擾
//
//	in	(offset	size)
//		 0	1.b	萔(26)
//		 1	1.b	jbgԍ
//		 2	1.b	R}h($52/$d2)
//		14	1.l	obt@AhX(擪AhX + 2 w)
//	out	(offset	size)
//		 3	1.b	G[R[h()
//		 4	1.b	V	    ()
//		18	1.l	UgXe[^X
//
//	@w胁fBȀ v1 ` DPB ŕԂ. ̃R}hŐݒ肷Kv
//	͈ȉ̒ʂ(ʓ DOS R[ݒ肷). Aobt
//	@AhX̓ItZbg 2 wAhXn̂Œӂ邱.
//
//	offset	size
//	 0	1.b	(hCuԍ)
//	 1	1.b	(jbgԍ)
//	 2	1.w	1 ZN^̃oCg
//	 4	1.b	1 NX^̃ZN^ - 1
//	 5	1.b	NX^ZN^̃Vtg
//			bit 7 = 1  MS-DOS ` FAT(16bit Intel z)
//	 6	1.w	FAT ̐擪ZN^ԍ
//	 8	1.b	FAT ̈̌
//	 9	1.b	FAT ̐߂ZN^(ʕ)
//	10	1.w	[gfBNgɓt@Č
//	12	1.w	f[^̈̐擪ZN^ԍ
//	14	1.w	NX^ + 1
//	16	1.w	[gfBNg̐擪ZN^ԍ
//	18	1.l	(hCowb_̃AhX)
//	22	1.b	(̕hCu)
//	23	1.b	(DPB gptO: 0)
//	24	1.l	( DPB ̃AhX)
//	28	1.w	(JgfBNg̃NX^ԍ: 0)
//	30	64.b	(JgfBNg)
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::GetDPB()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// DPB擾
	DWORD nDpb = GetAddr(a5 + 14);
	Human68k::dpb_t dpb;
	//GetDpb(nDpb, &dpb);	// 擾͕sv sv oOv p

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$52 %d DPB擾 DPB:%X", unit, nDpb);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	int nResult = windrv->GetFilesystem()->GetDPB(this, &dpb);

	LockXM();

	// ʂ̔f
	if (nResult >= 0) {
		SetDpb(nDpb, &dpb);
	}

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$53 - ZN^ǂݍ
//
//	in	(offset	size)
//		 1	1.B	jbgԍ
//		14	1.L	obt@AhX
//		18	1.L	ZN^
//		22	1.L	ZN^ԍ
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::DiskRead()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

	LockXM();

	DWORD nAddress = GetAddr(a5 + 14);	// AhX(ʃrbggtO)
	DWORD nSize = GetLong(a5 + 18);		// ZN^
	DWORD nSector = GetLong(a5 + 22);	// ZN^ԍ

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$53 %d ZN^ǂݍ AhX:%X ZN^:%X :%X", unit, nAddress, nSector, nSize);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	DWORD nResult = windrv->GetFilesystem()->DiskRead(this, nAddress, nSector, nSize);

	LockXM();

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$54 - ZN^
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::DiskWrite()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

	LockXM();

	DWORD nAddress = GetAddr(a5 + 14);	// AhX(ʃrbggtO)
	DWORD nSize = GetLong(a5 + 18);		// ZN^
	DWORD nSector = GetLong(a5 + 22);	// ZN^ԍ

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$53 %d ZN^ AhX:%X ZN^:%X :%X", unit, nAddress, nSector, nSize);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	DWORD nResult = windrv->GetFilesystem()->DiskWrite(this, nAddress, nSector, nSize);

	LockXM();

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$55 - IOCTRL
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::IoControl()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

	LockXM();

	// IOCTRL擾
	DWORD nParameter = GetLong(a5 + 14);	// p[^
	DWORD nFunction = GetWord(a5 + 18);		// @\ԍ
	Human68k::ioctrl_t ioctrl;
	GetIoctrl(nParameter, nFunction, &ioctrl);

	UnlockXM();

#ifdef WINDRV_LOG
	Log(Log::Normal, "$55 %d IOCTRL p[^:%X @\:%X", unit, nParameter, nFunction);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	int nResult = windrv->GetFilesystem()->IoControl(this, &ioctrl, nFunction);

	LockXM();

	// ʂ̔f
	if (nResult >= 0) {
		SetIoctrl(nParameter, nFunction, &ioctrl);
	}

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$56 - tbV
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Flush()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

#ifdef WINDRV_LOG
	Log(Log::Normal, "$56 %d tbV", unit);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	DWORD nResult = windrv->GetFilesystem()->Flush(this);

	LockXM();

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$57 - fBA`FbN
//
//	in	(offset	size)
//		 0	1.b	萔(26)
//		 1	1.b	jbgԍ
//		 2	1.b	R}h($57/$d7)
//	out	(offset	size)
//		 3	1.b	G[R[h()
//		 4	1.b	V	    ()
//		18	1.l	UgXe[^X
//
//	@fBAꂽۂ𒲂ׂ. Ăꍇ̃tH[}bg
//	mF͂̃R}hōs.
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::CheckMedia()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

#ifdef WINDRV_LOG
	Log(Log::Normal, "$57 %d fBA`FbN", unit);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	DWORD nResult = windrv->GetFilesystem()->CheckMedia(this);

	LockXM();

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	$58 - r
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Lock()
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);
	ASSERT(windrv);
	ASSERT(windrv->isValidUnit(unit));
	ASSERT(windrv->GetFilesystem());

#ifdef WINDRV_LOG
	Log(Log::Normal, "$58 %d r", unit);
#endif // WINDRV_LOG

	// t@CVXeĂяo
	DWORD nResult = windrv->GetFilesystem()->Lock(this);

	LockXM();

	// Il
	SetResult(nResult);

	UnlockXM();
}

//---------------------------------------------------------------------------
//
//	Il
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::SetResult(DWORD result)
{
	ASSERT(this);
	ASSERT(a5 <= 0xFFFFFF);

	// vIG[
	DWORD fatal = 0;
	switch (result) {
	case FS_FATAL_INVALIDUNIT: fatal = 0x5001; break;
	case FS_FATAL_INVALIDCOMMAND: fatal = 0x5003; break;
	case FS_FATAL_WRITEPROTECT: fatal = 0x700D; break;
	case FS_FATAL_MEDIAOFFLINE: fatal = 0x7002; break;
	}

	// ʂi[
	if (fatal) {
		// gC\ԂƂ́A(a5 + 18)Ă͂ȂB
		// ̌㔒т Retry IꍇAlǂݍŌ듮삵Ă܂B
		result = FS_INVALIDFUNC;
		SetByte(a5 + 3, fatal & 255);
		SetByte(a5 + 4, fatal >> 8);
		if ((fatal & 0x2000) == 0) {
			SetLong(a5 + 18, result);
		}
	} else {
		SetLong(a5 + 18, result);
	}

#if defined(WINDRV_LOG)
	// G[ȂΏI
	if (result < 0xFFFFFF80) return;

	// G[bZ[W
	TCHAR* szError;
	switch (result) {
	case FS_INVALIDFUNC: szError = "ȃt@NVR[hs܂"; break;
	case FS_FILENOTFND: szError = "w肵t@C܂"; break;
	case FS_DIRNOTFND: szError = "w肵fBNg܂"; break;
	case FS_OVEROPENED: szError = "I[vĂt@C܂"; break;
	case FS_CANTACCESS: szError = "fBNg{[x̓ANZXsł"; break;
	case FS_NOTOPENED: szError = "w肵nh̓I[vĂ܂"; break;
	case FS_INVALIDMEM: szError = "Ǘ̈悪j󂳂܂"; break;
	case FS_OUTOFMEM: szError = "sɕKvȃ܂"; break;
	case FS_INVALIDPTR: szError = "ȃǗ|C^w肵܂"; break;
	case FS_INVALIDENV: szError = "sȊw肵܂"; break;
	case FS_ILLEGALFMT: szError = "st@C̃tH[}bgُł"; break;
	case FS_ILLEGALMOD: szError = "I[ṽANZX[hُł"; break;
	case FS_INVALIDPATH: szError = "t@C̎wɌ肪܂"; break;
	case FS_INVALIDPRM: szError = "ȃp[^ŃR[܂"; break;
	case FS_INVALIDDRV: szError = "hCuwɌ肪܂"; break;
	case FS_DELCURDIR: szError = "JgfBNg͍폜ł܂"; break;
	case FS_NOTIOCTRL: szError = "IOCTRLłȂfoCXł"; break;
	case FS_LASTFILE: szError = "ȏt@C܂"; break;
	case FS_CANTWRITE: szError = "w̃t@C͏݂ł܂"; break;
	case FS_DIRALREADY: szError = "w̃fBNg͊ɓo^Ă܂"; break;
	case FS_CANTDELETE: szError = "t@Ĉō폜ł܂"; break;
	case FS_CANTRENAME: szError = "t@ĈŃl[ł܂"; break;
	case FS_DISKFULL: szError = "fBXNtŃt@C܂"; break;
	case FS_DIRFULL: szError = "fBNgtŃt@C܂"; break;
	case FS_CANTSEEK: szError = "ẅʒuɂ̓V[Nł܂"; break;
	case FS_SUPERVISOR: szError = "X[p[oCUԂŃX[poCUw肵܂"; break;
	case FS_THREADNAME: szError = "Xbh݂܂"; break;
	case FS_BUFWRITE: szError = "vZXԒʐM̃obt@݋֎~ł"; break;
	case FS_BACKGROUND: szError = "obNOEhvZXNł܂"; break;
	case FS_OUTOFLOCK: szError = "bN̈悪܂"; break;
	case FS_LOCKED: szError = "bNĂăANZXł܂"; break;
	case FS_DRIVEOPENED: szError = "w̃hCu̓nhI[vĂ܂"; break;
	case FS_LINKOVER: szError = "V{bNNlXg16𒴂܂"; break;
	case FS_FILEEXIST: szError = "t@C݂܂"; break;
	default: szError = "`̃G[ł"; break;
	}
	switch (fatal & 255) {
	case 0: break;
	case 1: szError = "ȃjbgԍw肵܂"; break;
	case 2: szError = "fBXNĂ܂"; break;
	case 3: szError = "ȃR}hԍw肵܂"; break;
	case 4: szError = "CRCG[܂"; break;
	case 5: szError = "fBXN̊Ǘ̈悪j󂳂Ă܂"; break;
	case 6: szError = "V[NɎs܂"; break;
	case 7: szError = "ȃfBAgp܂"; break;
	case 8: szError = "ZN^܂"; break;
	case 9: szError = "v^ȂĂ܂"; break;
	case 10: szError = "݃G[܂"; break;
	case 11: szError = "ǂݍ݃G[܂"; break;
	case 12: szError = "̑̃G[܂"; break;
	case 13: szError = "݋֎~̂ߎsł܂"; break;
	case 14: szError = "݂ł܂"; break;
	case 15: szError = "t@CLᔽ܂"; break;
	default: szError = "`̒vIG[ł"; break;
	}

	Log(Log::Warning, "$%X %d %s(%d)", command, unit, szError, result);
#endif // WINDRV_LOG
}

//---------------------------------------------------------------------------
//
//	oCgǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL CWindrv::GetByte(DWORD addr) const
{
	ASSERT(this);
	ASSERT(memory);
	ASSERT(addr <= 0xffffff);

	// 8bit
	return memory->ReadOnly(addr);
}

//---------------------------------------------------------------------------
//
//	oCg
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::SetByte(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT(memory);
	ASSERT(addr <= 0xffffff);
	ASSERT(data < 0x100);

	// 8bit
	memory->WriteByte(addr, data);
}

//---------------------------------------------------------------------------
//
//	[hǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL CWindrv::GetWord(DWORD addr) const
{
	DWORD data;

	ASSERT(this);
	ASSERT(memory);
	ASSERT(addr <= 0xffffff);

	// 16bit
	data = memory->ReadOnly(addr);
	data <<= 8;
	data |= memory->ReadOnly(addr + 1);

	return data;
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::SetWord(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT(memory);
	ASSERT(addr <= 0xffffff);
	ASSERT(data < 0x10000);

	// 16bit
	memory->WriteWord(addr, data);
}

//---------------------------------------------------------------------------
//
//	Oǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL CWindrv::GetLong(DWORD addr) const
{
	DWORD data;

	ASSERT(this);
	ASSERT(memory);
	ASSERT(addr <= 0xffffff);

	// 32bit
	data = memory->ReadOnly(addr);
	data <<= 8;
	data |= memory->ReadOnly(addr + 1);
	data <<= 8;
	data |= memory->ReadOnly(addr + 2);
	data <<= 8;
	data |= memory->ReadOnly(addr + 3);

	return data;
}

//---------------------------------------------------------------------------
//
//	O
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::SetLong(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT(memory);
	ASSERT(addr <= 0xffffff);

	// 32bit
	memory->WriteWord(addr, (WORD)(data >> 16));
	memory->WriteWord(addr + 2, (WORD)data);
}

//---------------------------------------------------------------------------
//
//	AhXǂݍ
//
//---------------------------------------------------------------------------
DWORD FASTCALL CWindrv::GetAddr(DWORD addr) const
{
	DWORD data;

	ASSERT(this);
	ASSERT(memory);
	ASSERT(addr <= 0xffffff);

	// 24bit(ŏ1oCg͖)
	data = memory->ReadOnly(addr + 1);
	data <<= 8;
	data |= memory->ReadOnly(addr + 2);
	data <<= 8;
	data |= memory->ReadOnly(addr + 3);

	return data;
}

//---------------------------------------------------------------------------
//
//	AhX
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::SetAddr(DWORD addr, DWORD data)
{
	ASSERT(this);
	ASSERT(memory);
	ASSERT(addr <= 0xffffff);
	ASSERT(data <= 0xffffff);

	// 24bit(ŏ1oCg͕K0)
	data &= 0xffffff;
	memory->WriteWord(addr, (WORD)(data >> 16));
	memory->WriteWord(addr + 2, (WORD)data);
}

//---------------------------------------------------------------------------
//
//	NAMESTSpXǂݍ
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::GetNameStsPath(DWORD addr, Human68k::namests_t *pNamests) const
{
	DWORD offset;

	ASSERT(this);
	ASSERT(pNamests);
	ASSERT(addr <= 0xFFFFFF);

	// ChJ[h
	pNamests->wildcard = (BYTE)GetByte(addr + 0);

	// hCuԍ
	pNamests->drive = (BYTE)GetByte(addr + 1);

	// pX
	for (offset=0; offset<sizeof(pNamests->path); offset++) {
		pNamests->path[offset] = (BYTE)GetByte(addr + 2 + offset);
	}

	// t@C1
	memset(pNamests->name, 0x20, sizeof(pNamests->name));

	// gq
	memset(pNamests->ext, 0x20, sizeof(pNamests->ext));

	// t@C2
	memset(pNamests->add, 0, sizeof(pNamests->add));

#if defined(WINDRV_LOG)
{
	TCHAR szPath[_MAX_PATH];
	pNamests->GetCopyPath((BYTE*)szPath);	// WARNING: UnicodevC

	Log(Log::Detail, "Path %s", szPath);
}
#endif // WINDRV_LOG
}

//---------------------------------------------------------------------------
//
//	NAMESTSǂݍ
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::GetNameSts(DWORD addr, Human68k::namests_t *pNamests) const
{
	DWORD offset;

	ASSERT(this);
	ASSERT(pNamests);
	ASSERT(addr <= 0xFFFFFF);

	// ChJ[h
	pNamests->wildcard = (BYTE)GetByte(addr + 0);

	// hCuԍ
	pNamests->drive = (BYTE)GetByte(addr + 1);

	// pX
	for (offset=0; offset<sizeof(pNamests->path); offset++) {
		pNamests->path[offset] = (BYTE)GetByte(addr + 2 + offset);
	}

	// t@C1
	for (offset=0; offset<sizeof(pNamests->name); offset++) {
		pNamests->name[offset] = (BYTE)GetByte(addr + 67 + offset);
	}

	// gq
	for (offset=0; offset<sizeof(pNamests->ext); offset++) {
		pNamests->ext[offset] = (BYTE)GetByte(addr + 75 + offset);
	}

	// t@C2
	for (offset=0; offset<sizeof(pNamests->add); offset++) {
		pNamests->add[offset] = (BYTE)GetByte(addr + 78 + offset);
	}

#if defined(WINDRV_LOG)
{
	TCHAR szPath[_MAX_PATH];
	pNamests->GetCopyPath((BYTE*)szPath);	// WARNING: UnicodevC

	TCHAR szFilename[_MAX_PATH];
	pNamests->GetCopyFilename((BYTE*)szFilename);	// WARNING: UnicodevC

	if (pNamests->wildcard == 0xFF) {
		Log(Log::Detail, "Path %s", szPath);
	} else {
		Log(Log::Detail, "Filename %s%s", szPath, szFilename);
	}
}
#endif // WINDRV_LOG
}

//---------------------------------------------------------------------------
//
//	FILESǂݍ
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::GetFiles(DWORD addr, Human68k::files_t* pFiles) const
{
	ASSERT(this);
	ASSERT(pFiles);
	ASSERT(addr <= 0xFFFFFF);

	// 
	pFiles->fatr = (BYTE)GetByte(addr + 0);		// Read only
	pFiles->drive = (BYTE)GetByte(addr + 1);	// Read only
	pFiles->sector = GetLong(addr + 2);
	//pFiles->sector2 = (WORD)GetWord(addr + 6);	// Read only
	pFiles->offset = (WORD)GetWord(addr + 8);

#if 0
	DWORD offset;

	// t@C
	for (offset=0; offset<sizeof(pFiles->name); offset++) {
		pFiles->name[offset] = (BYTE)GetByte(addr + 10 + offset);
	}

	// gq
	for (offset=0; offset<sizeof(pFiles->ext); offset++) {
		pFiles->ext[offset] = (BYTE)GetByte(addr + 18 + offset);
	}
#endif

#if 0
	// t@C
	pFiles->attr = (BYTE)GetByte(addr + 21);
	pFiles->time = (WORD)GetWord(addr + 22);
	pFiles->date = (WORD)GetWord(addr + 24);
	pFiles->size = GetLong(addr + 26);

	// tt@C
	for (offset=0; offset<sizeof(pFiles->full); offset++) {
		pFiles->full[offset] = (BYTE)GetByte(addr + 30 + offset);
	}
#else
	pFiles->attr = 0;
	pFiles->time = 0;
	pFiles->date = 0;
	pFiles->size = 0;
	memset(pFiles->full, 0, sizeof(pFiles->full));
#endif
}

//---------------------------------------------------------------------------
//
//	FILES
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::SetFiles(DWORD addr, const Human68k::files_t* pFiles)
{
	DWORD offset;

	ASSERT(this);
	ASSERT(pFiles);
	ASSERT(addr <= 0xFFFFFF);

	SetLong(addr + 2, pFiles->sector);
	SetWord(addr + 8, pFiles->offset);

#if 0
	// 
	SetByte(addr + 0, pFiles->fatr);	// Read only
	SetByte(addr + 1, pFiles->drive);	// Read only
	SetWord(addr + 6, pFiles->sector2);	// Read only

	// t@C
	for (offset=0; offset<sizeof(pFiles->name); offset++) {
		SetByte(addr + 10 + offset, pFiles->name[offset]);
	}

	// gq
	for (offset=0; offset<sizeof(pFiles->ext); offset++) {
		SetByte(addr + 18 + offset, pFiles->ext[offset]);
	}
#endif

	// t@C
	SetByte(addr + 21, pFiles->attr);
	SetWord(addr + 22, pFiles->time);
	SetWord(addr + 24, pFiles->date);
	SetLong(addr + 26, pFiles->size);

	// tt@C
	for (offset=0; offset<sizeof(pFiles->full); offset++) {
		SetByte(addr + 30 + offset, pFiles->full[offset]);
	}

#if defined(WINDRV_LOG)
{
	TCHAR szAttribute[16];
	BYTE nAttribute = pFiles->attr;
	for (int i = 0; i < 8; i++) {
		TCHAR c = '-';
		if ((nAttribute & 0x80) != 0)
			c = "XLADVSHR"[i];
		szAttribute[i] = c;
		nAttribute <<= 1;
	}
	szAttribute[8] = '\0';

	Log(Log::Detail, "%s %s %d", szAttribute, pFiles->full, pFiles->size);
}
#endif // WINDRV_LOG
}

//---------------------------------------------------------------------------
//
//	FCBǂݍ
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::GetFcb(DWORD addr, Human68k::fcb_t* pFcb) const
{
	ASSERT(this);
	ASSERT(pFcb);
	ASSERT(addr <= 0xFFFFFF);

	// FCB
	pFcb->fileptr = GetLong(addr + 6);
	pFcb->mode = (WORD)GetWord(addr + 14);
	//pFcb->zero = GetLong(addr + 32);

#if 0
	DWORD i;

	// t@C
	for (i = 0; i < sizeof(pFcb->name); i++) {
		pFcb->name[i] = (BYTE)GetByte(addr + 36 + i);
	}

	// gq
	for (i = 0; i < sizeof(pFcb->ext); i++) {
		pFcb->ext[i] = (BYTE)GetByte(addr + 44 + i);
	}

	// t@C2
	for (i = 0; i < sizeof(pFcb->add); i++) {
		pFcb->add[i] = (BYTE)GetByte(addr + 48 + i);
	}
#endif

	// 
	pFcb->attr = (BYTE)GetByte(addr + 47);

	// FCB
	pFcb->time = (WORD)GetWord(addr + 58);
	pFcb->date = (WORD)GetWord(addr + 60);
	//pFcb->cluster = (WORD)GetWord(addr + 62);
	pFcb->size = GetLong(addr + 64);
}

//---------------------------------------------------------------------------
//
//	FCB
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::SetFcb(DWORD addr, const Human68k::fcb_t* pFcb)
{
	ASSERT(this);
	ASSERT(pFcb);
	ASSERT(addr <= 0xFFFFFF);

	// FCB
	SetLong(addr + 6, pFcb->fileptr);
	SetWord(addr + 14, pFcb->mode);
	// SetLong(addr + 32, pFcb->zero);

#if 0
	DWORD i;

	// t@C
	for (i = 0; i < sizeof(pFcb->name); i++) {
		SetByte(addr + 36 + i, pFcb->name[i]);
	}

	// gq
	for (i = 0; i < sizeof(pFcb->ext); i++) {
		SetByte(addr + 44 + i, pFcb->ext[i]);
	}

	// t@C2
	for (i = 0; i < sizeof(pFcb->add); i++) {
		SetByte(addr + 48 + i, pFcb->add[i]);
	}
#endif

	// 
	SetByte(addr + 47, pFcb->attr);

	// FCB
	SetWord(addr + 58, pFcb->time);
	SetWord(addr + 60, pFcb->date);
	//SetWord(addr + 62, pFcb->cluster);
	SetLong(addr + 64, pFcb->size);
}

//---------------------------------------------------------------------------
//
//	CAPACITY
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::SetCapacity(DWORD addr, const Human68k::capacity_t* pCapacity)
{
	ASSERT(this);
	ASSERT(pCapacity);
	ASSERT(addr <= 0xffffff);

#ifdef WINDRV_LOG
	Log(Log::Detail, "Free:%d Clusters:%d Sectors:%d Bytes:%d",
		pCapacity->free, pCapacity->clusters, pCapacity->sectors, pCapacity->bytes);
#endif // WINDRV_LOG

	SetWord(addr + 0, pCapacity->free);
	SetWord(addr + 2, pCapacity->clusters);
	SetWord(addr + 4, pCapacity->sectors);
	SetWord(addr + 6, pCapacity->bytes);
}

//---------------------------------------------------------------------------
//
//	DPB
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::SetDpb(DWORD addr, const Human68k::dpb_t* pDpb)
{
	ASSERT(this);
	ASSERT(pDpb);
	ASSERT(addr <= 0xFFFFFF);

	// DPB
	SetWord(addr + 0, pDpb->sector_size);
	SetByte(addr + 2, pDpb->cluster_size);
	SetByte(addr + 3, pDpb->shift);
	SetWord(addr + 4, pDpb->fat_sector);
	SetByte(addr + 6, pDpb->fat_max);
	SetByte(addr + 7, pDpb->fat_size);
	SetWord(addr + 8, pDpb->file_max);
	SetWord(addr + 10, pDpb->data_sector);
	SetWord(addr + 12, pDpb->cluster_max);
	SetWord(addr + 14, pDpb->root_sector);
	SetByte(addr + 20, pDpb->media);
}

//---------------------------------------------------------------------------
//
//	IOCTRLǂݍ
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::GetIoctrl(DWORD param, DWORD func, Human68k::ioctrl_t* pIoctrl)
{
	ASSERT(this);
	ASSERT(pIoctrl);

	switch (func) {
	case 2:
		// fBAĔF
		pIoctrl->param = param;
		return;

	case -2:
		// IvVݒ
		ASSERT(param <= 0xFFFFFF);
		pIoctrl->param = GetLong(param);
		return;

#if 0
	case 0:
		// fBAID̊l
		return;

	case 1:
		// Human68k݊̂߂̃_~[
		return;

	case -1:
		// 풓
		return;

	case -3:
		// IvVl
		return;
#endif
	}
}

//---------------------------------------------------------------------------
//
//	IOCTRL
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::SetIoctrl(DWORD param, DWORD func, const Human68k::ioctrl_t* pIoctrl)
{
	ASSERT(this);
	ASSERT(pIoctrl);

	switch (func) {
	case 0:
		// fBAID̊l
		ASSERT(param <= 0xFFFFFF);
		SetWord(param, pIoctrl->media);
		return;

	case 1:
		// Human68k݊̂߂̃_~[
		ASSERT(param <= 0xFFFFFF);
		SetLong(param, pIoctrl->param);
		return;

	case -1:
		// 풓
		ASSERT(param <= 0xFFFFFF);
		{
			for (int i = 0; i < 8; i++) SetByte(param + i, pIoctrl->buffer[i]);
		}
		return;

	case -3:
		// IvVl
		ASSERT(param <= 0xFFFFFF);
		SetLong(param, pIoctrl->param);
		return;

#if 0
	case 2:
		// fBAĔF
		return;

	case -2:
		// IvVݒ
		return;
#endif
	}
}

//---------------------------------------------------------------------------
//
//	p[^ǂݍ
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::GetParameter(DWORD addr, BYTE* pOption, DWORD nSize)
{
	ASSERT(this);
	ASSERT(addr <= 0xFFFFFF);
	ASSERT(pOption);

	DWORD nMode = 0;
	BYTE* p = pOption;
	for (DWORD i = 0; i < nSize - 2; i++) {
		BYTE c = (BYTE)GetByte(addr + i);
		*p++ = c;
		switch (nMode) {
		case 0:
			if (c == '\0') {
				return;
			}
			nMode = 1;
			break;
		case 1:
			if (c == '\0') nMode = 0;
			break;
		}
	}

	*p++ = '\0';
	*p++ = '\0';
}

#ifdef WINDRV_LOG
//---------------------------------------------------------------------------
//
//	Oo
//
//---------------------------------------------------------------------------
void FASTCALL CWindrv::Log(DWORD level, char* format, ...) const
{
	ASSERT(this);
	ASSERT(format);
	ASSERT(windrv);

	va_list args;
	va_start(args, format);
	char message[512];
	vsprintf(message, format, args);
	va_end(args);

	windrv->Log(level, message);
}

//---------------------------------------------------------------------------
//
//	Oo
//
//---------------------------------------------------------------------------
void FASTCALL Windrv::Log(DWORD level, char* message) const
{
	ASSERT(this);
	ASSERT(message);

	LOG((enum Log::loglevel)level, "%s", message);
}
#endif // WINDRV_LOG
