//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2004 ohD(ytanaka@ipc-tokai.or.jp)
//	Modified (C) 2006 co (cogoodgmail.com)
//	[ Windrv ]
//
//---------------------------------------------------------------------------

#if !defined(windrv_h)
#define windrv_h

#include "device.h"

//őXbh
#define WINDRV_THREAD_MAX	3

//WINDRV݊̃T|[g
#define WINDRV_SUPPORT_COMPATIBLE

//Oo͗L
#ifdef _DEBUG
#define WINDRV_LOG
#endif // _DEBUG

class FileSys;

//---------------------------------------------------------------------------
//
//	Xe[^XR[h`
//
//---------------------------------------------------------------------------
#define FS_INVALIDFUNC		0xffffffff	// ȃt@NVR[hs
#define FS_FILENOTFND		0xfffffffe	// w肵t@CȂ
#define FS_DIRNOTFND		0xfffffffd	// w肵fBNgȂ
#define FS_OVEROPENED		0xfffffffc	// I[vĂt@C
#define FS_CANTACCESS		0xfffffffb	// fBNg{[x̓ANZXs
#define FS_NOTOPENED		0xfffffffa	// w肵nh̓I[vĂȂ
#define FS_INVALIDMEM		0xfffffff9	// Ǘ̈悪j󂳂ꂽ
#define FS_OUTOFMEM			0xfffffff8	// sɕKvȃȂ
#define FS_INVALIDPTR		0xfffffff7	// ȃǗ|C^w肵
#define FS_INVALIDENV		0xfffffff6	// sȊw肵
#define FS_ILLEGALFMT		0xfffffff5	// st@C̃tH[}bgُ
#define FS_ILLEGALMOD		0xfffffff4	// I[ṽANZX[hُ
#define FS_INVALIDPATH		0xfffffff3	// t@C̎wɌ肪
#define FS_INVALIDPRM		0xfffffff2	// ȃp[^ŃR[
#define FS_INVALIDDRV		0xfffffff1	// hCuwɌ肪
#define FS_DELCURDIR		0xfffffff0	// JgfBNg͍폜łȂ
#define FS_NOTIOCTRL		0xffffffef	// IOCTRLłȂfoCX
#define FS_LASTFILE			0xffffffee	// ȏt@CȂ
#define FS_CANTWRITE		0xffffffed	// w̃t@C͏݂łȂ
#define FS_DIRALREADY		0xffffffec	// w̃fBNg͊ɓo^Ă
#define FS_CANTDELETE		0xffffffeb	// t@Ĉō폜łȂ
#define FS_CANTRENAME		0xffffffea	// t@ĈŃl[łȂ
#define FS_DISKFULL			0xffffffe9	// fBXNtŃt@CȂ
#define FS_DIRFULL			0xffffffe8	// fBNgtŃt@CȂ
#define FS_CANTSEEK			0xffffffe7	// ẅʒuɂ̓V[NłȂ
#define FS_SUPERVISOR		0xffffffe6	// X[p[oCUԂŃX[poCUw肵
#define FS_THREADNAME		0xffffffe5	// Xbh݂
#define FS_BUFWRITE			0xffffffe4	// vZXԒʐM̃obt@݋֎~
#define FS_BACKGROUND		0xffffffe3	// obNOEhvZXNłȂ
#define FS_OUTOFLOCK		0xffffffe0	// bN̈悪Ȃ
#define FS_LOCKED			0xffffffdf	// bNĂăANZXłȂ
#define FS_DRIVEOPENED		0xffffffde	// w̃hCu̓nhI[vĂ
#define FS_LINKOVER			0xffffffdd	// V{bNNlXg16𒴂
#define FS_FILEEXIST		0xffffffb0	// t@C݂

#define FS_FATAL_INVALIDUNIT	0xFFFFFFA0	// sȃjbgԍ
#define FS_FATAL_INVALIDCOMMAND	0xFFFFFFA1	// sȃR}hԍ
#define FS_FATAL_WRITEPROTECT	0xFFFFFFA2	// ݋֎~ᔽ
#define FS_FATAL_MEDIAOFFLINE	0xFFFFFFA3	// fBAĂȂ

//===========================================================================
//
//	Human68k
//
//===========================================================================
#define HUMAN68K_MAX_PATH	96
class Human68k {
public:
	// t@Crbg
	enum {
		AT_READONLY	= 0x01,
		AT_HIDDEN	= 0x02,
		AT_SYSTEM	= 0x04,
		AT_VOLUME	= 0x08,
		AT_DIRECTORY= 0x10,
		AT_ARCHIVE	= 0x20,
		AT_ALL		= 0xFF,
	};

	// t@CI[v[h
	enum {
		OP_READ		= 0,
		OP_WRITE	= 1,
		OP_READWRITE= 2,
	};

	// V[N
	enum {
		SK_BEGIN	= 0,
		SK_CURRENT	= 1,
		SK_END		= 2,
	};

	// namests\
	typedef struct {
		BYTE wildcard;			// ChJ[h
		BYTE drive;				// hCuԍ
		BYTE path[65];			// pX(TufBNg+/)
		BYTE name[8];			// t@C (PADDING 0x20)
		BYTE ext[3];			// gq (PADDING 0x20)
		BYTE add[10];			// t@Cǉ (PADDING 0x00)

		// 擾(UnicodeΉ\)
		void FASTCALL GetCopyPath(BYTE* szPath) const;
		void FASTCALL GetCopyFilename(BYTE* szFilename) const;
	} namests_t;

	// files\
	typedef struct {
		BYTE fatr;				// + 0 鑮				Ǎp
		BYTE drive;				// + 1 hCuԍ				Ǎp
		DWORD sector;			// + 2 fBNg̃ZN^No	DOS _FILES 擪AhXőp
		//WORD sector2;			// + 6 fBNg̃ZN^No	ڍוs gp
		WORD offset;			// + 8 fBNg̈ʒu		ڍוs
		//BYTE name[8];			// +10 Ɨpt@C			Ǎp gp
		//BYTE ext[3];			// +18 Ɨpgq				Ǎp gp
		BYTE attr;				// +21 t@C				p
		WORD time;				// +22 ŏIύX				p
		WORD date;				// +24 ŏIύX				p
		DWORD size;				// +26 t@CTCY			p
		BYTE full[23];			// +30 tt@C			p
	} files_t;

	// FCB\
	typedef struct {
		//BYTE pad00[6];		// + 0`+ 5
		DWORD fileptr;			// + 6`+ 9	t@C|C^
		//BYTE pad01[4];		// +10`+13
		WORD mode;				// +14`+15	I[v[h
		//BYTE pad02[16];		// +16`+31
		//DWORD zero;			// +32`+35	I[v̂Ƃ0܂Ă gp
		//BYTE name[8];			// +36`+43	t@C (PADDING 0x20) gp
		//BYTE ext[3];			// +44`+46	gq (PADDING 0x20) gp
		BYTE attr;				// +47		t@C
		//BYTE add[10];			// +48`+57	t@Cǉ (PADDING 0x00) gp
		WORD time;				// +58`+59	ŏIύX
		WORD date;				// +60`+61	ŏIύX
		//WORD cluster;			// +62`+63	NX^ԍ gp
		DWORD size;				// +64`+67	t@CTCY
		//BYTE pad03[28];		// +68`+95
	} fcb_t;

	// capacity\
	typedef struct {
		WORD free;				// + 0 gp\ȃNX^
		WORD clusters;			// + 2 NX^
		WORD sectors;			// + 4 NX^̃ZN^
		WORD bytes;				// + 6 ZN^̃oCg
	} capacity_t;

	// ctrldrive\
	typedef struct {
		BYTE status;			// +13	
	} ctrldrive_t;

	// DPB\
	typedef struct {
		WORD sector_size;		// + 0	1 ZN^̃oCg
		BYTE cluster_size;		// + 2	1 NX^̃ZN^-1
		BYTE shift;				// + 3	NX^ZN^̃Vtg
		WORD fat_sector;		// + 4	FAT ̐擪ZN^ԍ
		BYTE fat_max;			// + 6	FAT ̈̌
		BYTE fat_size;			// + 7	FAT ̐߂ZN^(ʕ)
		WORD file_max;			// + 8	[gfBNgɓt@Č
		WORD data_sector;		// +10	f[^̈̐擪ZN^ԍ
		WORD cluster_max;		// +12	NX^+1
		WORD root_sector;		// +14	[gfBNg̐擪ZN^ԍ
		//DWORD driverentry;	// +16	foCXhCoւ̃|C^
		BYTE media;				// +20	fBAʎq
		//BYTE flag;			// +21	DPB gptO
	} dpb_t;

	// fBNgGg\
	typedef struct {
		BYTE name[8];			// + 0	t@C (PADDING 0x20)
		BYTE ext[3];			// + 8	gq (PADDING 0x20)
		BYTE attr;				// +11	t@C
		BYTE add[10];			// +12	t@Cǉ (PADDING 0x00)
		WORD time;				// +22	ŏIύX
		WORD date;				// +24	ŏIύX
		WORD cluster;			// +26	NX^ԍ
		DWORD size;				// +28	t@CTCY
	} dirent_t;

	// IOCTRL\
	typedef union {
		BYTE buffer[8];
		DWORD param;
		WORD media;
	} ioctrl_t;
};

//===========================================================================
//
//	R}hnh
//
//===========================================================================
class CWindrv {
public:
	// {t@NV
	CWindrv(Windrv* pWindrv, Memory* pMemory, DWORD nHandle = 0);
										// RXgN^
	virtual ~CWindrv();
										// fXgN^

	// Xbh
	BOOL FASTCALL Start();
										// XbhN
	BOOL FASTCALL Terminate();
										// Xbh~

	// WindrvpOAPI
	void FASTCALL Execute(DWORD nA5);
										// R}hs
#ifdef WINDRV_SUPPORT_COMPATIBLE
	DWORD FASTCALL ExecuteCompatible(DWORD nA5);
										// R}hs (WINDRV݊)
#endif // WINDRV_SUPPORT_COMPATIBLE
	DWORD FASTCALL GetHandle() const { ASSERT(this); return m_nHandle; }
										// g̃nh(zԍ)l
	BOOL FASTCALL isExecute() const { ASSERT(this); return m_bExecute; }
										// R}hsǂmF

	// CWindrvManagerpOAPI
	void FASTCALL SetAlloc(BOOL bAlloc) { ASSERT(this); m_bAlloc = bAlloc; }
	BOOL FASTCALL isAlloc() const { ASSERT(this); return m_bAlloc; }
										// nhgpǂmF

	// FileSyspOAPI
	DWORD FASTCALL GetUnit() const { ASSERT(this); return unit; }
										// jbgԍ擾
	Memory* FASTCALL GetMemory() const { ASSERT(this); return memory; }
										// jbgԍ擾
	void FASTCALL LockXM() { ASSERT(this); if (m_bReady) ::LockVM(); }
										// VMւ̃ANZXJn
	void FASTCALL UnlockXM() { ASSERT(this); if (m_bReady) ::UnlockVM(); }
										// VMւ̃ANZXI
	void FASTCALL Ready();
										// R}h҂VMXbhsĊJ

	// Xbh
	static DWORD WINAPI Run(VOID* pThis);
										// XbhsJn|Cg
	void FASTCALL Runner();
										// Xbh

private:
	// R}hnh
	void FASTCALL ExecuteCommand();
										// R}hnh

	void FASTCALL InitDrive();
										// $40 - 
	void FASTCALL CheckDir();
										// $41 - fBNg`FbN
	void FASTCALL MakeDir();
										// $42 - fBNg쐬
	void FASTCALL RemoveDir();
										// $43 - fBNg폜
	void FASTCALL Rename();
										// $44 - t@CύX
	void FASTCALL Delete();
										// $45 - t@C폜
	void FASTCALL Attribute();
										// $46 - t@C擾/ݒ
	void FASTCALL Files();
										// $47 - t@C(First)
	void FASTCALL NFiles();
										// $48 - t@C(NFiles)
	void FASTCALL Create();
										// $49 - t@C쐬
	void FASTCALL Open();
										// $4A - t@CI[v
	void FASTCALL Close();
										// $4B - t@CN[Y
	void FASTCALL Read();
										// $4C - t@Cǂݍ
	void FASTCALL Write();
										// $4D - t@C
	void FASTCALL Seek();
										// $4E - t@CV[N
	void FASTCALL TimeStamp();
										// $4F - t@C擾/ݒ
	void FASTCALL GetCapacity();
										// $50 - eʎ擾
	void FASTCALL CtrlDrive();
										// $51 - hCuԌ/
	void FASTCALL GetDPB();
										// $52 - DPB擾
	void FASTCALL DiskRead();
										// $53 - ZN^ǂݍ
	void FASTCALL DiskWrite();
										// $54 - ZN^
	void FASTCALL IoControl();
										// $55 - IOCTRL
	void FASTCALL Flush();
										// $56 - tbV
	void FASTCALL CheckMedia();
										// $57 - fBA`FbN
	void FASTCALL Lock();
										// $58 - r

	// Il
	void FASTCALL SetResult(DWORD result);
										// Il

	// ANZX
	DWORD FASTCALL GetByte(DWORD addr) const;
										// oCgǂݍ
	void FASTCALL SetByte(DWORD addr, DWORD data);
										// oCg
	DWORD FASTCALL GetWord(DWORD addr) const;
										// [hǂݍ
	void FASTCALL SetWord(DWORD addr, DWORD data);
										// [h
	DWORD FASTCALL GetLong(DWORD addr) const;
										// Oǂݍ
	void FASTCALL SetLong(DWORD addr, DWORD data);
										// O
	DWORD FASTCALL GetAddr(DWORD addr) const;
										// AhXǂݍ
	void FASTCALL SetAddr(DWORD addr, DWORD data);
										// AhX

	// \̕ϊ
	void FASTCALL GetNameStsPath(DWORD addr, Human68k::namests_t* pNamests) const;
										// NAMESTSpXǂݍ
	void FASTCALL GetNameSts(DWORD addr, Human68k::namests_t* pNamests) const;
										// NAMESTSǂݍ
	void FASTCALL GetFiles(DWORD addr, Human68k::files_t* pFiles) const;
										// FILESǂݍ
	void FASTCALL SetFiles(DWORD addr, const Human68k::files_t* pFiles);
										// FILES
	void FASTCALL GetFcb(DWORD addr, Human68k::fcb_t* pFcb) const;
										// FCBǂݍ
	void FASTCALL SetFcb(DWORD addr, const Human68k::fcb_t* pFcb);
										// FCB
	void FASTCALL SetCapacity(DWORD addr, const Human68k::capacity_t* pCapacity);
										// CAPACITY
	void FASTCALL SetDpb(DWORD addr, const Human68k::dpb_t* pDpb);
										// DPB
	void FASTCALL GetIoctrl(DWORD param, DWORD func, Human68k::ioctrl_t* pIoctrl);
										// IOCTRLǂݍ
	void FASTCALL SetIoctrl(DWORD param, DWORD func, const Human68k::ioctrl_t* pIoctrl);
										// IOCTRL
	void FASTCALL GetParameter(DWORD addr, BYTE* pOption, DWORD nSize);
										// p[^ǂݍ

#ifdef WINDRV_LOG
	// O
	void Log(DWORD level, char* format, ...) const;
										// Oo
#endif // WINDRV_LOG

	// R}hnhp
	Windrv* windrv;
										// ݒe
	Memory* memory;
										// 
	DWORD a5;
										// NGXgwb_
	DWORD unit;
										// jbgԍ
	DWORD command;
										// R}hԍ

	// XbhǗp
	DWORD m_nHandle;
										// obt@ԍnhƂĎg(0`THREAD_MAX - 1)
	BOOL m_bAlloc;
										// nhgp̂ƂTRUE
	BOOL m_bExecute;
										// R}hŝƂTRUE
	BOOL m_bReady;
										// VMXbhsĊĴƂTRUE
	BOOL m_bTerminate;
										// XbhpÎƂTRUE
	HANDLE m_hThread;
										// Xbhnh
	HANDLE m_hEventStart;
										// R}hsJnʒm
	HANDLE m_hEventReady;
										// VMXbhsĊJʒm
};

//===========================================================================
//
//	R}hnhǗ
//
//===========================================================================
class CWindrvManager {
public:
	void FASTCALL Init(Windrv* pWindrv, Memory* pMemory);
										// 
	void FASTCALL Clean();
										// I
	void FASTCALL Reset();
										// Zbg

	CWindrv* FASTCALL Alloc();
										// 󂫃Xbhm
	CWindrv* FASTCALL Search(DWORD nHandle);
										// Xbh
	void FASTCALL Free(CWindrv* p);
										// XbhJ

private:
	CWindrv* m_pThread[WINDRV_THREAD_MAX];
										// R}hnh
};

//===========================================================================
//
//	Windrv
//
//===========================================================================
class Windrv : public MemDevice
{
public:
	// Windrv
	enum {
		WINDRV_MODE_NONE = 0,
		WINDRV_MODE_ENABLE = 1,
		WINDRV_MODE_COMPATIBLE = 2,
		WINDRV_MODE_DUAL = 3,
		WINDRV_MODE_DISABLE = 255,
	};

	// f[^`
	typedef struct {
		// RtBO
		DWORD enable;					// WindrvT|[g 0: 1:WindrvXM (2:Windrv݊)

		// hCuEt@CǗ
		DWORD drives;					// mۂꂽhCu (FileSysANZXE`FbNp)

		// vZX
		FileSys *fs;					// t@CVXe
	} windrv_t;

public:
	// {t@NV
	Windrv(VM *p);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL Reset();
										// Zbg
	BOOL FASTCALL Save(Fileio *fio, int ver);
										// Z[u
	BOOL FASTCALL Load(Fileio *fio, int ver);
										// [h
	void FASTCALL ApplyCfg(const Config *config);
										// ݒKp

	// foCX
	DWORD FASTCALL ReadByte(DWORD addr);
										// oCgǂݍ
	void FASTCALL WriteByte(DWORD addr, DWORD data);
										// oCg
	DWORD FASTCALL ReadOnly(DWORD addr) const;
										// ǂݍ݂̂

	// OAPI
	void FASTCALL SetFileSys(FileSys *fs);
										// t@CVXeݒ

	// R}hnhp OAPI
	void FASTCALL SetUnitMax(DWORD nUnitMax) { ASSERT(this); windrv.drives = nUnitMax; }
										// ݂̃jbgԍݒ
	BOOL FASTCALL isInvalidUnit(DWORD unit) const;
										// jbgԍ`FbN
#ifdef _DEBUG
	BOOL FASTCALL isValidUnit(DWORD unit) const { ASSERT(this); return unit < windrv.drives; }
										// jbgԍ`FbN (ASSERTp)
#endif // _DEBUG
	FileSys* FASTCALL GetFilesystem() const { ASSERT(this); return windrv.fs; }
										// t@CVXe̊l

#ifdef WINDRV_LOG
	// O
	void FASTCALL Log(DWORD level, char* message) const;
										// Oo
#endif // WINDRV_LOG

private:
#ifdef WINDRV_SUPPORT_COMPATIBLE
	void FASTCALL Execute();
										// R}hs
#endif // WINDRV_SUPPORT_COMPATIBLE
	void FASTCALL ExecuteAsynchronous();
										// R}hsJn 񓯊
	DWORD FASTCALL StatusAsynchronous();
										// Xe[^Xl 񓯊
	void FASTCALL ReleaseAsynchronous();
										// nhJ 񓯊

	windrv_t windrv;
										// f[^
	CWindrvManager m_cThread;
										// R}hnhǗ
};

//===========================================================================
//
//	t@CVXe
//
//	ׂďz֐ƂB
//
//===========================================================================
class FileSys
{
public:
	// {t@NV
	//FileSys();
										// RXgN^
	//virtual ~FileSys() = 0;
										// fXgN^

	// EI
	virtual DWORD FASTCALL Init(CWindrv* ps, DWORD nDriveMax, const BYTE* pOption) = 0;
										// $40 - 
	virtual void FASTCALL Reset() = 0;
										// Zbg(SN[Y)

	// R}hnh
	virtual int FASTCALL CheckDir(CWindrv* ps, const Human68k::namests_t* pNamests) = 0;
										// $41 - fBNg`FbN
	virtual int FASTCALL MakeDir(CWindrv* ps, const Human68k::namests_t* pNamests) = 0;
										// $42 - fBNg쐬
	virtual int FASTCALL RemoveDir(CWindrv* ps, const Human68k::namests_t* pNamests) = 0;
										// $43 - fBNg폜
	virtual int FASTCALL Rename(CWindrv* ps, const Human68k::namests_t* pNamests, const Human68k::namests_t* pNamestsNew) = 0;
										// $44 - t@CύX
	virtual int FASTCALL Delete(CWindrv* ps, const Human68k::namests_t* pNamests) = 0;
										// $45 - t@C폜
	virtual int FASTCALL Attribute(CWindrv* ps, const Human68k::namests_t* pNamests, DWORD nHumanAttribute) = 0;
										// $46 - t@C擾/ݒ
	virtual int FASTCALL Files(CWindrv* ps, const Human68k::namests_t* pNamests, DWORD nKey, Human68k::files_t* info) = 0;
										// $47 - t@C(First)
	virtual int FASTCALL NFiles(CWindrv* ps, DWORD nKey, Human68k::files_t* info) = 0;
										// $48 - t@C(Next)
	virtual int FASTCALL Create(CWindrv* ps, const Human68k::namests_t* pNamests, DWORD nKey, Human68k::fcb_t* pFcb, DWORD nAttribute, BOOL bForce) = 0;
										// $49 - t@C쐬
	virtual int FASTCALL Open(CWindrv* ps, const Human68k::namests_t* pNamests, DWORD nKey, Human68k::fcb_t* pFcb) = 0;
										// $4A - t@CI[v
	virtual int FASTCALL Close(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb) = 0;
										// $4B - t@CN[Y
	virtual int FASTCALL Read(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb, DWORD nAddress, DWORD nSize) = 0;
										// $4C - t@Cǂݍ
	virtual int FASTCALL Write(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb, DWORD nAddress, DWORD nSize) = 0;
										// $4D - t@C
	virtual int FASTCALL Seek(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb, DWORD nMode, int nOffset) = 0;
										// $4E - t@CV[N
	virtual DWORD FASTCALL TimeStamp(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb, WORD nFatDate, WORD nFatTime) = 0;
										// $4F - t@C擾/ݒ
	virtual int FASTCALL GetCapacity(CWindrv* ps, Human68k::capacity_t* cap) = 0;
										// $50 - eʎ擾
	virtual int FASTCALL CtrlDrive(CWindrv* ps, Human68k::ctrldrive_t* pCtrlDrive) = 0;
										// $51 - hCuԌ/
	virtual int FASTCALL GetDPB(CWindrv* ps, Human68k::dpb_t* pDpb) = 0;
										// $52 - DPB擾
	virtual int FASTCALL DiskRead(CWindrv* ps, DWORD nAddress, DWORD nSector, DWORD nSize) = 0;
										// $53 - ZN^ǂݍ
	virtual int FASTCALL DiskWrite(CWindrv* ps, DWORD nAddress, DWORD nSector, DWORD nSize) = 0;
										// $54 - ZN^
	virtual int FASTCALL IoControl(CWindrv* ps, Human68k::ioctrl_t* pIoctrl, DWORD nFunction) = 0;
										// $55 - IOCTRL
	virtual int FASTCALL Flush(CWindrv* ps) = 0;
										// $56 - tbV
	virtual int FASTCALL CheckMedia(CWindrv* ps) = 0;
										// $57 - fBA`FbN
	virtual int FASTCALL Lock(CWindrv* ps) = 0;
										// $58 - r

	// G[nh
	//virtual DWORD FASTCALL GetLastError(DWORD nUnit) const = 0;
										// ŏIG[擾
};

#endif // windrv_h
