//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2005 ohD(ytanaka@ipc-tokai.or.jp)
//	[ ʒ` ]
//
//---------------------------------------------------------------------------

#if !defined(xm6_h)
#define xm6_h

//---------------------------------------------------------------------------
//
//	{萔
//
//---------------------------------------------------------------------------
#if !defined(FALSE)
#define FALSE		0
#define TRUE		(!FALSE)
#endif	// FALSE
#if !defined(NULL)
#define NULL		0
#endif	// NULL

//---------------------------------------------------------------------------
//
//	{}N
//
//---------------------------------------------------------------------------
#if !defined(ASSERT)
#if !defined(NDEBUG)
#define ASSERT(cond)	assert(cond)
#else
#define ASSERT(cond)	((void)0)
#endif	// NDEBUG
#endif	// ASSERT

#if !defined(ASSERT_DIAG)
#if !defined(NDEBUG)
#define ASSERT_DIAG()	AssertDiag()
#else
#define ASSERT_DIAG()	((void)0)
#endif	// NDEBUG
#endif	// ASSERT_DIAG

//---------------------------------------------------------------------------
//
//	{^`
//
//---------------------------------------------------------------------------
typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;
typedef int BOOL;

//---------------------------------------------------------------------------
//
//	ID}N
//
//---------------------------------------------------------------------------
#define MAKEID(a, b, c, d)	((DWORD)((a<<24) | (b<<16) | (c<<8) | d))

//---------------------------------------------------------------------------
//
//	NX錾
//
//---------------------------------------------------------------------------
class VM;
										// z}V
class Config;
										// RtBM[V
class Device;
										// foCXėp
class MemDevice;
										// }bvhfoCXėp
class Log;
										// O
class Event;
										// Cxg
class Scheduler;
										// XPW[
class CPU;
										// CPU MC68000
class Memory;
										// AhX OHM2
class Fileio;
										// t@Co
class SRAM;
										// X^eBbNRAM
class SysPort;
										// VXe|[g MESSIAH
class TVRAM;
										// eLXgVRAM
class VC;
										// rfIRg[ VIPS&CATHY
class CRTC;
										// CRTC VICON
class RTC;
										// RTC RP5C15
class PPI;
										// PPI i8255A
class DMAC;
										// DMAC HD63450
class MFP;
										// MFP MC68901
class FDC;
										// FDC uPD72065
class FDD;
										// FDD FD55GFR
class IOSC;
										// I/ORg[ IOSC-2
class SASI;
										// SASI
class Sync;
										// IuWFNg
class OPMIF;
										// OPM YM2151
class Keyboard;
										// L[{[h
class ADPCM;
										// ADPCM MSM6258V
class GVRAM;
										// OtBbNVRAM
class Sprite;
										// XvCgRAM
class SCC;
										// SCC Z8530
class Mouse;
										// }EX
class Printer;
										// v^
class AreaSet;
										// GAZbg
class Render;
										// _
class Windrv;
										// Windrv
class FDI;
										// tbs[fBXNC[W
class Disk;
										// SASI/SCSIfBXN
class MIDI;
										// MIDI YM3802
class Filepath;
										// t@CpX
class JoyDevice;
										// WCXeBbNfoCX
class FileSys;
										// t@CVXe
class SCSI;
										// SCSI MB89352
class Mercury;
										// Mercury-Unit

#endif	// xm6_h
