/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.flume.appender;

import com.google.common.base.Preconditions;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.flume.node.NodeConfiguration;
import org.apache.flume.node.NodeManager;
import org.apache.flume.node.nodemanager.NodeConfigurationAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlumeNode
implements LifecycleAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlumeNode.class);
    private LifecycleState lifecycleState;
    private final NodeManager nodeManager;
    private final NodeConfigurationAware configurationAware;
    private final NodeConfiguration conf;

    public FlumeNode(NodeConfigurationAware configurationAware, NodeManager manager, NodeConfiguration conf) {
        this.nodeManager = manager;
        this.conf = conf;
        this.configurationAware = configurationAware;
    }

    public void start() {
        Preconditions.checkState((this.nodeManager != null ? 1 : 0) != 0, (Object)"Node manager can not be null");
        LOGGER.info("Flume node starting");
        this.configurationAware.startAllComponents(this.conf);
        this.lifecycleState = LifecycleState.START;
    }

    public void stop() {
        LOGGER.info("Flume node stopping");
        this.configurationAware.stopAllComponents();
        this.lifecycleState = LifecycleState.STOP;
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public NodeConfiguration getConfiguration() {
        return this.conf;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }
}

