/*
 * Decompiled with CFR 0.152.
 */
package com.jhe.hexed;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JHexEditorData {
    private byte[] _bufferData;
    private int _bufferOffset;
    private int _bufferLength;

    public JHexEditorData(byte[] buff) {
        this._bufferData = buff;
    }

    public int getBufferLength() {
        return this._bufferLength;
    }

    public void setBufferByte(int offset, byte value) {
        this._bufferData[this._bufferOffset + offset] = value;
    }

    public byte getBufferByte(int offset) {
        return this._bufferData[this._bufferOffset + offset];
    }

    public void setBufferView(int offset, int length) {
        this._bufferOffset = offset;
        this._bufferLength = length;
    }

    public boolean isAtOrigin() {
        return this._bufferOffset == 0;
    }

    public int find(byte[] values, int fromIndex) {
        int bufferIndex = fromIndex + this._bufferOffset;
        while (bufferIndex < this._bufferLength) {
            int valueIndex = 0;
            while (valueIndex < values.length) {
                if (this._bufferData[bufferIndex + valueIndex] != values[valueIndex]) break;
                ++valueIndex;
            }
            if (valueIndex == values.length) {
                return bufferIndex - this._bufferOffset;
            }
            ++bufferIndex;
        }
        return -1;
    }

    public void saveToStream(OutputStream file, int start, int end) throws IOException {
        file.write(this._bufferData, this._bufferOffset + start, end - start + 1);
    }

    public void loadFromStream(InputStream file, int pos) throws IOException {
        int i = pos;
        while (i < this._bufferLength) {
            int ch = file.read();
            if (ch < 0) {
                return;
            }
            this._bufferData[this._bufferOffset + i] = (byte)ch;
            ++i;
        }
    }
}

