/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI;

import emulator.GUI.FrameRegistry;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

public class PersistentFrame
extends JFrame
implements WindowListener {
    private Preferences cfg;
    private String pref_prefix;
    private String appName;
    public static final Rectangle GEOMETRY = new Rectangle(0, 0, 640, 480);

    public static Rectangle getDefaultGeometry() {
        return GEOMETRY;
    }

    public PersistentFrame(String name, String appName) {
        super(name);
        this.appName = appName;
        this.pref_prefix = String.valueOf(appName) + "/" + name + ".";
        this.cfg = Preferences.userNodeForPackage(this.getClass());
        this.addWindowListener(this);
        FrameRegistry.getInstance().registerFrame(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public int loadInt(String id, int defaultValue) {
        return this.cfg.getInt(String.valueOf(this.pref_prefix) + id, defaultValue);
    }

    public void saveInt(String id, int value) {
        this.cfg.putInt(String.valueOf(this.pref_prefix) + id, value);
    }

    public void restorePosition() {
        Rectangle bounds = new Rectangle();
        bounds.x = this.loadInt("window.x", PersistentFrame.getDefaultGeometry().x);
        bounds.y = this.loadInt("window.y", PersistentFrame.getDefaultGeometry().y);
        bounds.width = this.loadInt("window.width", PersistentFrame.getDefaultGeometry().width);
        bounds.height = this.loadInt("window.height", PersistentFrame.getDefaultGeometry().height);
        this.setBounds(bounds);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.savePosition();
    }

    public void savePosition() {
        Rectangle bounds = this.getBounds();
        this.saveInt("window.x", bounds.x);
        this.saveInt("window.y", bounds.y);
        this.saveInt("window.width", bounds.width);
        this.saveInt("window.height", bounds.height);
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }
}

