/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI;

import emulator.GUI.display.VicFrame;
import emulator.GUI.joystick.VicJoystickFrame;
import emulator.GUI.keyboard.VicKey;
import emulator.GUI.keyboard.VicKeyboard;
import emulator.GUI.keyboard.VicKeyboardFrame;
import emulator.GUI.keyboard.VicKeyboardMap;
import emulator.GUI.tape.VicTapeFrame;
import emulator.hardware.CPU;
import emulator.hardware.clock.Clock;
import emulator.hardware.io.peripherals.Joystick;
import emulator.hardware.io.peripherals.KeyboardMatrix;
import emulator.hardware.io.peripherals.VicTape;
import emulator.shell.DebugShell;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.swing.SwingUtilities;

public class VicUI {
    private static KeyboardMatrix matrix;
    private static Joystick joystick;
    private static CPU cpu;
    private static Clock clock;
    private static String keyboard_map_name;
    private static VicTape tape;
    private static String appName;

    private static void createAndShowGUI() {
        VicKeyboard keyboard = VicUI.createKeyboard();
        VicUI.createAndShowVideo(keyboard);
        VicUI.createAndShowKeyboard(keyboard);
        if (joystick != null) {
            VicUI.createAndShowJoystick();
        }
        if (tape != null) {
            VicUI.createAndShowTape();
        }
    }

    private static VicKeyboard createKeyboard() {
        VicKeyboard keyboard = new VicKeyboard(5);
        keyboard.addKey(0, "Left Arrow", new VicKey("<-", 1.0, 0.5).attachToMatrix(matrix, 0, 1));
        keyboard.addKey(0, "1", new VicKey("!\n1").attachToMatrix(matrix, 0, 0));
        keyboard.addKey(0, "2", new VicKey("\"\n2").attachToMatrix(matrix, 0, 7));
        keyboard.addKey(0, "3", new VicKey("#\n3").attachToMatrix(matrix, 1, 0));
        keyboard.addKey(0, "4", new VicKey("$\n4").attachToMatrix(matrix, 1, 7));
        keyboard.addKey(0, "5", new VicKey("%\n5").attachToMatrix(matrix, 2, 0));
        keyboard.addKey(0, "6", new VicKey("&\n6").attachToMatrix(matrix, 2, 7));
        keyboard.addKey(0, "7", new VicKey("'\n7").attachToMatrix(matrix, 3, 0));
        keyboard.addKey(0, "8", new VicKey("(\n8").attachToMatrix(matrix, 3, 7));
        keyboard.addKey(0, "9", new VicKey(")\n9").attachToMatrix(matrix, 4, 0));
        keyboard.addKey(0, "0", new VicKey("0").attachToMatrix(matrix, 4, 7));
        keyboard.addKey(0, "Plus", new VicKey("+").attachToMatrix(matrix, 5, 0));
        keyboard.addKey(0, "Minus", new VicKey("-").attachToMatrix(matrix, 5, 7));
        keyboard.addKey(0, "Pound", new VicKey("\u00a3").attachToMatrix(matrix, 6, 0));
        keyboard.addKey(0, "Home", new VicKey("CLR\nHOME").attachToMatrix(matrix, 6, 7));
        keyboard.addKey(0, "Del", new VicKey("INST\nDEL").attachToMatrix(matrix, 7, 0));
        keyboard.addKey(0, "F1", new VicKey("F1", 1.5, 1.0).attachToMatrix(matrix, 7, 4));
        keyboard.addKey(1, "Ctrl", new VicKey("CTRL", 1.5, 0.5).attachToMatrix(matrix, 0, 2));
        keyboard.addKey(1, "Q", new VicKey("Q").attachToMatrix(matrix, 0, 6));
        keyboard.addKey(1, "W", new VicKey("W").attachToMatrix(matrix, 1, 1));
        keyboard.addKey(1, "E", new VicKey("E").attachToMatrix(matrix, 1, 6));
        keyboard.addKey(1, "R", new VicKey("R").attachToMatrix(matrix, 2, 1));
        keyboard.addKey(1, "T", new VicKey("T").attachToMatrix(matrix, 2, 6));
        keyboard.addKey(1, "Y", new VicKey("Y").attachToMatrix(matrix, 3, 1));
        keyboard.addKey(1, "U", new VicKey("U").attachToMatrix(matrix, 3, 6));
        keyboard.addKey(1, "I", new VicKey("I").attachToMatrix(matrix, 4, 1));
        keyboard.addKey(1, "O", new VicKey("O").attachToMatrix(matrix, 4, 6));
        keyboard.addKey(1, "P", new VicKey("P").attachToMatrix(matrix, 5, 1));
        keyboard.addKey(1, "@", new VicKey("@").attachToMatrix(matrix, 5, 6));
        keyboard.addKey(1, "Star", new VicKey("*").attachToMatrix(matrix, 6, 1));
        keyboard.addKey(1, "Up Arrow", new VicKey("|").attachToMatrix(matrix, 6, 6));
        keyboard.addKey(1, "Restore", new VicKey("RESTORE", 1.5).attachToMatrix(matrix, -1, -1));
        keyboard.addKey(1, "F3", new VicKey("F3", 1.5, 1.0).attachToMatrix(matrix, 7, 5));
        keyboard.addKey(2, "Run Stop", new VicKey("RUN\nSTOP").attachToMatrix(matrix, 0, 3));
        keyboard.addKey(2, null, new VicKey("SHIFT\nLOCK"));
        keyboard.addKey(2, "A", new VicKey("A").attachToMatrix(matrix, 1, 2));
        keyboard.addKey(2, "S", new VicKey("S").attachToMatrix(matrix, 1, 5));
        keyboard.addKey(2, "D", new VicKey("D").attachToMatrix(matrix, 2, 2));
        keyboard.addKey(2, "F", new VicKey("F").attachToMatrix(matrix, 2, 5));
        keyboard.addKey(2, "G", new VicKey("G").attachToMatrix(matrix, 3, 2));
        keyboard.addKey(2, "H", new VicKey("H").attachToMatrix(matrix, 3, 5));
        keyboard.addKey(2, "J", new VicKey("J").attachToMatrix(matrix, 4, 2));
        keyboard.addKey(2, "K", new VicKey("K").attachToMatrix(matrix, 4, 5));
        keyboard.addKey(2, "L", new VicKey("L").attachToMatrix(matrix, 5, 2));
        keyboard.addKey(2, "Colon", new VicKey("[\n:").attachToMatrix(matrix, 5, 5));
        keyboard.addKey(2, "Semicolon", new VicKey("]\n;").attachToMatrix(matrix, 6, 2));
        keyboard.addKey(2, "Equal", new VicKey("=").attachToMatrix(matrix, 6, 5));
        keyboard.addKey(2, "Return", new VicKey("RETURN", 2.0).attachToMatrix(matrix, 7, 1));
        keyboard.addKey(2, "F5", new VicKey("F5", 1.5, 1.5).attachToMatrix(matrix, 7, 6));
        keyboard.addKey(3, "Commodore", new VicKey("C=").attachToMatrix(matrix, 0, 5));
        keyboard.addKey(3, "Left Shift", new VicKey("SHIFT", 1.5).attachToMatrix(matrix, 1, 3));
        keyboard.addKey(3, "Z", new VicKey("Z").attachToMatrix(matrix, 1, 4));
        keyboard.addKey(3, "X", new VicKey("X").attachToMatrix(matrix, 2, 3));
        keyboard.addKey(3, "C", new VicKey("C").attachToMatrix(matrix, 2, 4));
        keyboard.addKey(3, "V", new VicKey("V").attachToMatrix(matrix, 3, 3));
        keyboard.addKey(3, "B", new VicKey("B").attachToMatrix(matrix, 3, 4));
        keyboard.addKey(3, "N", new VicKey("N").attachToMatrix(matrix, 4, 3));
        keyboard.addKey(3, "M", new VicKey("M").attachToMatrix(matrix, 4, 4));
        keyboard.addKey(3, "Comma", new VicKey("<\n,").attachToMatrix(matrix, 5, 3));
        keyboard.addKey(3, "Period", new VicKey(">\n.").attachToMatrix(matrix, 5, 4));
        keyboard.addKey(3, "Slash", new VicKey("?\n/").attachToMatrix(matrix, 6, 3));
        keyboard.addKey(3, "Right Shift", new VicKey("SHIFT", 1.5).attachToMatrix(matrix, 6, 4));
        keyboard.addKey(3, "Cursor Down", new VicKey("^\nCRSR\nv").attachToMatrix(matrix, 7, 3));
        keyboard.addKey(3, "Cursor Right", new VicKey("<CRSR>").attachToMatrix(matrix, 7, 2));
        keyboard.addKey(3, "F7", new VicKey("F7", 1.5, 1.5).attachToMatrix(matrix, 7, 7));
        keyboard.addKey(4, "Space", new VicKey("SPACE", 9.0, 3.0).attachToMatrix(matrix, 0, 4));
        return keyboard;
    }

    private static VicTapeFrame createAndShowTape() {
        VicTapeFrame frame = new VicTapeFrame(appName, tape);
        frame.restorePosition();
        frame.setVisible(true);
        return frame;
    }

    private static VicJoystickFrame createAndShowJoystick() {
        VicJoystickFrame frame = new VicJoystickFrame(appName, joystick);
        frame.restorePosition();
        frame.setVisible(true);
        return frame;
    }

    private static VicKeyboardFrame createAndShowKeyboard(VicKeyboard keyboard) {
        VicKeyboardFrame frame = new VicKeyboardFrame(appName, keyboard);
        frame.restorePosition();
        frame.setVisible(true);
        return frame;
    }

    private static VicFrame createAndShowVideo(VicKeyboard keyboard) {
        VicKeyboardMap keyboard_map = new VicKeyboardMap(keyboard, joystick);
        try {
            keyboard_map.load(new FileInputStream(keyboard_map_name));
        }
        catch (FileNotFoundException e) {
            DebugShell.getInstance().getErr().println("Keyboard map \"" + keyboard_map_name + "\"not found!");
        }
        VicFrame frame = new VicFrame(appName, cpu, clock, keyboard_map);
        frame.restorePosition();
        frame.setVisible(true);
        return frame;
    }

    public static void run() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VicUI.createAndShowGUI();
            }
        });
    }

    public static KeyboardMatrix getMatrix() {
        return matrix;
    }

    public static void setMatrix(KeyboardMatrix matrix) {
        VicUI.matrix = matrix;
    }

    public static Joystick getJoystick() {
        return joystick;
    }

    public static void setJoystick(Joystick joystick) {
        VicUI.joystick = joystick;
    }

    public static CPU getCpu() {
        return cpu;
    }

    public static void setCpu(CPU cpu) {
        VicUI.cpu = cpu;
    }

    public static Clock getClock() {
        return clock;
    }

    public static void setClock(Clock clock) {
        VicUI.clock = clock;
    }

    public static String getKeyboardMapName() {
        return keyboard_map_name;
    }

    public static void setKeyboardMapName(String keyboard_map_name) {
        VicUI.keyboard_map_name = keyboard_map_name;
    }

    public static void setTape(VicTape tape) {
        VicUI.tape = tape;
    }

    public static void setAppName(String appName) {
        VicUI.appName = appName;
    }
}

