/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.display;

import emulator.GUI.display.VicDisplayRegistry;
import emulator.GUI.display.VicScreen;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Observable;
import java.util.Observer;

public class VicCanvas
extends Canvas
implements Observer {
    private static final int PIXEL_HEIGHT = 2;
    private static final int PIXEL_WIDTH = 3;
    private static final long serialVersionUID = -8942291577898864075L;
    Dimension dimension;
    VicScreen contents;

    VicCanvas(int width, int height) {
        this.dimension = new Dimension(width, height);
        this.setSize(3 * width, 2 * height);
        this.contents = new VicScreen(3, this.getWidth(), 2, this.getHeight());
        this.contents.addObserver(this);
        VicDisplayRegistry.registerDisplay("VicScreen", this.contents);
    }

    @Override
    public void paint(Graphics g) {
        this.contents.lock();
        g.drawImage(this.contents, 0, 0, Color.black, null);
        this.contents.unlock();
    }

    public Dimension getScreenSize() {
        return this.dimension;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void addObserver(Observer arg0) {
        this.contents.addObserver(arg0);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.repaint();
    }
}

