/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.display;

import com.jhe.hexed.ClipboardInterface;
import com.l2fprod.common.swing.StatusBar;
import emulator.GUI.PersistentFrame;
import emulator.GUI.display.VicCanvas;
import emulator.GUI.keyboard.VicKeyboardMap;
import emulator.GUI.util.Clipboard;
import emulator.cbm.basic.BasicHelper;
import emulator.hardware.CPU;
import emulator.hardware.clock.Clock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class VicFrame
extends PersistentFrame {
    private VicKeyboardMap keyboard_map;
    private VicCanvas canvas;
    private JPopupMenu popup;
    private ClipboardInterface clipboard = new Clipboard();
    private StatusBar status_bar;

    public VicFrame(String appName, CPU cpu, Clock clock, VicKeyboardMap keyboard_map) throws HeadlessException {
        super("Vic Output", appName);
        this.keyboard_map = keyboard_map;
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        this.canvas = new VicCanvas(208, 260);
        this.canvas.addMouseListener(new MousePopupListener());
        this.canvas.addKeyListener(new KeyboardInputListener());
        this.add((Component)this.canvas, "Center");
        this.status_bar = new StatusBar();
        this.status_bar.setZones(new String[]{"status", "speed"}, (Component[])new JComponent[]{new JLabel(), new JLabel()}, new String[]{"66%", "*"});
        this.add((Component)this.status_bar, "South");
        this.popup = new JPopupMenu();
        JMenuItem item_clear = new JMenuItem("Clear Buffer");
        item_clear.setActionCommand("clear");
        item_clear.addActionListener(new PopupMenuListener());
        this.popup.add(item_clear);
        JMenuItem item_paste = new JMenuItem("Paste", new ImageIcon("images/paste_icon.png"));
        item_paste.setActionCommand("paste");
        item_paste.addActionListener(new PopupMenuListener());
        this.popup.add(item_paste);
        this.showStatus("Ready");
        this.showSpeed("???");
        cpu.addRunningStateObserver(new CpuStateObserver());
        clock.addClockSpeedObserver(new ClockSpeedObserver());
    }

    private void showSpeed(String speed_text) {
        ((JLabel)this.status_bar.getZone("speed")).setText("Clock: " + speed_text);
    }

    private void showStatus(String status_text) {
        ((JLabel)this.status_bar.getZone("status")).setText(status_text);
    }

    public void onClear() {
        BasicHelper.clearText();
    }

    public void onPaste() {
        BasicHelper.enterText(this.clipboard.getClipboardContents());
    }

    class ClockSpeedObserver
    implements Observer {
        ClockSpeedObserver() {
        }

        @Override
        public void update(Observable state, Object clock_freq) {
            String[] units = new String[]{"Hz", "kHz", "MHz", "GHz", "THz"};
            long freq = (Long)clock_freq;
            long decimals = 0L;
            int unit = 0;
            while (freq > 1000L) {
                ++unit;
                decimals = decimals > 500L ? freq % 1000L + 1L : freq % 1000L;
                freq /= 1000L;
            }
            String speed_string = Long.toString(freq);
            if (decimals > 0L) {
                String decimals_string = "000" + Long.toString(decimals);
                speed_string = String.valueOf(speed_string) + "." + decimals_string.substring(decimals_string.length() - 3);
            }
            speed_string = String.valueOf(speed_string) + " " + units[unit];
            VicFrame.this.showSpeed(speed_string);
        }
    }

    class CpuStateObserver
    implements Observer {
        CpuStateObserver() {
        }

        @Override
        public void update(Observable state, Object run_state) {
            VicFrame.this.showStatus((Boolean)run_state != false ? "Running" : "Halted");
        }
    }

    class KeyboardInputDirectListener
    extends KeyAdapter {
        KeyboardInputDirectListener() {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char key = event.getKeyChar();
            if (key != '\uffff') {
                if (Character.isLowerCase(key)) {
                    this.putKey(Character.toUpperCase(key));
                } else if (Character.isUpperCase(key)) {
                    this.putKey(Character.toLowerCase(key));
                } else {
                    this.putKey(key);
                }
            }
            event.consume();
        }

        private void putKey(char key) {
            String buf = new String();
            buf = String.valueOf(buf) + key;
            BasicHelper.enterText(buf);
        }
    }

    class KeyboardInputListener
    extends KeyAdapter {
        KeyboardInputListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (VicFrame.this.keyboard_map.doKeyboardEvent(event)) {
                event.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
            if (VicFrame.this.keyboard_map.doKeyboardEvent(event)) {
                event.consume();
            }
        }
    }

    class MousePopupListener
    extends MouseAdapter {
        MousePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                VicFrame.this.popup.show(VicFrame.this.canvas, e.getX(), e.getY());
            }
        }
    }

    class PopupMenuListener
    implements ActionListener {
        PopupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("clear")) {
                VicFrame.this.onClear();
            } else if (event.getActionCommand().equals("paste")) {
                VicFrame.this.onPaste();
            }
        }
    }
}

