/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.io;

import emulator.util.AddressRange;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import layout.SpringUtilities;

public class ShiftPanel
extends JPanel {
    private JTextField latchEdit = new JTextField("%MMMMMMMM");
    private JTextField shiftEdit = new JTextField("%MMMMMMMM");
    private JTextField modeEdit = new JTextField("0");
    private String[] modeText;

    public ShiftPanel(String title, String[] modes) {
        this.modeText = modes;
        this.initPanel(title);
    }

    private void initPanel(String title) {
        this.setLayout(new SpringLayout());
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.add(new JLabel("Latch"));
        this.add(this.latchEdit);
        this.add(new JLabel("Value"));
        this.add(this.shiftEdit);
        this.add(new JLabel("Mode"));
        this.add(this.modeEdit);
        SpringUtilities.makeGrid(this, 3, 2, 5, 5, 5, 5);
    }

    public void setShiftValue(int shiftValue) {
        this.shiftEdit.setText("%" + AddressRange.toBinaryString(shiftValue, 8));
    }

    public int getShiftValue() {
        return AddressRange.addressFromString(this.shiftEdit.getText());
    }

    public void setLatchValue(int latchValue) {
        this.latchEdit.setText("%" + AddressRange.toBinaryString(latchValue, 8));
    }

    public int getLatchValue() {
        return AddressRange.addressFromString(this.latchEdit.getText());
    }

    public void setModeValue(int modeValue) {
        this.modeEdit.setText("" + modeValue);
        if (modeValue >= 0 && modeValue < this.modeText.length) {
            this.modeEdit.setToolTipText(this.modeText[modeValue]);
        } else {
            this.modeEdit.setToolTipText("???");
        }
    }

    public int getModeValue() {
        return Integer.parseInt(this.modeEdit.getText());
    }
}

