/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.io;

import emulator.hardware.HwWord;
import emulator.util.AddressRange;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import layout.SpringUtilities;

public class TimerPanel
extends JPanel {
    private JTextField timerEdit = new JTextField("$MMMM");
    private JTextField latchEdit = new JTextField("$MMMM");
    private JTextField modeEdit = new JTextField("0");
    private String[] modeText;

    public TimerPanel(String title, String[] modes) {
        this.modeText = modes;
        this.initPanel(title);
    }

    private void initPanel(String title) {
        this.setLayout(new SpringLayout());
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.add(new JLabel("Latch"));
        this.add(this.latchEdit);
        this.add(new JLabel("Timer"));
        this.add(this.timerEdit);
        this.add(new JLabel("Mode"));
        this.add(this.modeEdit);
        SpringUtilities.makeGrid(this, 3, 2, 5, 5, 5, 5);
    }

    public void setTimerValue(int timerValue) {
        this.timerEdit.setText("$" + new HwWord((long)timerValue).toString());
    }

    public int getTimerValue() {
        return AddressRange.addressFromString(this.timerEdit.getText());
    }

    public void setLatchValue(int latchValue) {
        this.latchEdit.setText("$" + new HwWord((long)latchValue).toString());
    }

    public int getLatchValue() {
        return AddressRange.addressFromString(this.latchEdit.getText());
    }

    public void setModeValue(int modeValue) {
        this.modeEdit.setText("" + modeValue);
        if (modeValue >= 0 && modeValue < this.modeText.length) {
            this.modeEdit.setToolTipText(this.modeText[modeValue]);
        } else {
            this.modeEdit.setToolTipText("???");
        }
    }

    public int getModeValue() {
        return Integer.parseInt(this.modeEdit.getText());
    }
}

