/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.keyboard;

import emulator.GUI.keyboard.VicKeyboard;
import emulator.hardware.io.peripherals.Button;
import emulator.hardware.io.peripherals.Joystick;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VicKeyboardMap {
    static Logger logger = LogManager.getLogger((String)VicKeyboardMap.class.getName());
    private static final String SCANCODE = "scancode=";
    private VicKeyboard keyboard;
    private HashMap<String, String> key_map;
    private Joystick joystick;

    public VicKeyboardMap(VicKeyboard keyboard, Joystick joystick) {
        this.keyboard = keyboard;
        this.joystick = joystick;
        this.key_map = new HashMap();
    }

    public boolean doKeyboardEvent(KeyEvent event) {
        int scan_code = this.getScanCodeFromKeyEvent(event);
        String key = "(" + scan_code + "," + event.getKeyLocation() + ")";
        String key_name = this.key_map.get(key);
        logger.trace("(doKeyboardEvent) Key: " + key + " = " + key_name);
        if (key_name != null) {
            Button button = null;
            button = key_name.length() == 4 && key_name.substring(0, 3).equalsIgnoreCase("joy") ? this.joystick.getButton(key_name.charAt(3) - 48) : this.keyboard.getKey(key_name);
            if (button != null) {
                if (event.getID() == 401) {
                    button.press();
                } else if (event.getID() == 402) {
                    button.release();
                }
            }
        }
        return false;
    }

    private int getScanCodeFromKeyEvent(KeyEvent event) {
        String key_string = event.paramString();
        int scan_code_start = key_string.indexOf(SCANCODE);
        int scan_code_end = scan_code_start + SCANCODE.length();
        while (scan_code_end < key_string.length()) {
            if (!Character.isDigit(key_string.charAt(scan_code_end))) break;
            ++scan_code_end;
        }
        String scan_code = key_string.substring(scan_code_start + SCANCODE.length(), scan_code_end);
        return Integer.parseInt(scan_code);
    }

    public void save(OutputStream output_stream) {
        PrintStream out = new PrintStream(output_stream);
        for (Map.Entry<String, String> key_info : this.key_map.entrySet()) {
            out.println(String.valueOf(key_info.getValue()) + "=" + key_info.getKey());
        }
    }

    public void load(InputStream input_stream) {
        this.key_map.clear();
        InputStreamReader reader = new InputStreamReader(input_stream);
        BufferedReader in = new BufferedReader(reader);
        String line = null;
        try {
            while ((line = in.readLine()) != null) {
                int equal_pos;
                if (line.length() == 0 || line.charAt(0) == ';' || (equal_pos = line.indexOf(61)) <= 0) continue;
                String key_name = line.substring(0, equal_pos);
                String key = line.substring(equal_pos + 1);
                this.key_map.put(key, key_name);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

