/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.keyboard;

import emulator.GUI.keyboard.VicKey;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;

public class VicMouseEvent
extends MouseAdapter {
    private JButton button;
    private VicKey key;
    private boolean key_state;
    private Color default_color;
    private Color selected_color;

    VicMouseEvent(JButton button, VicKey key) {
        this.button = button;
        this.key = key;
        this.key_state = false;
        this.default_color = button.getForeground();
        this.selected_color = Color.RED;
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (arg0.getButton() == 1) {
            this.pressKey();
        } else if (arg0.getButton() == 3) {
            if (this.key_state) {
                this.releaseKey();
            } else {
                this.pressKey();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (arg0.getButton() == 1) {
            this.releaseKey();
        }
    }

    private void pressKey() {
        this.key.press();
        this.key_state = true;
        this.button.setForeground(this.selected_color);
    }

    private void releaseKey() {
        this.key.release();
        this.key_state = false;
        this.button.setForeground(this.default_color);
    }
}

