/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.tape;

import emulator.hardware.io.peripherals.VicTape;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class VicTapePanel
extends JPanel
implements ActionListener {
    private static final int STATE_IDLE = 0;
    private static final int STATE_PLAY = 1;
    private static final int STATE_RECORD = 2;
    private int state = 0;
    private boolean motor_on = false;
    private JButton button_record;
    private JButton button_play;
    private JButton button_rewind;
    private JButton button_forward;
    private JButton button_stop;
    private JButton button_eject;
    private JLabel motor_led;
    private JLabel save_led;
    private JTextField display;
    private JTextField counter;
    private VicTape tape;

    public VicTapePanel(VicTape tape) {
        this.tape = tape;
        this.initPanel();
        this.updateState();
        tape.addMotorObserver(new MotorStateObserver());
    }

    private void updateState() {
        this.button_record.setEnabled(this.state == 0);
        this.button_play.setEnabled(this.state == 0);
        this.button_rewind.setEnabled(this.state == 0);
        this.button_forward.setEnabled(this.state == 0);
        this.button_stop.setEnabled(this.state != 0);
        this.button_eject.setEnabled(this.state == 0);
        this.save_led.setIcon(new ImageIcon(this.state == 2 ? "images/red-on-16.png" : "images/red-off-16.png"));
        this.motor_led.setIcon(new ImageIcon(this.motor_on ? "images/green-on-16.png" : "images/green-off-16.png"));
        this.display.setText("Track " + (this.tape.getCurrentTrack() + 1) + "/" + this.tape.getTrackCount() + " - " + this.tape.getCurrentLength());
        this.tape.setSwitch(this.state == 0, this.state == 2);
    }

    private void initPanel() {
        this.button_record = this.createButton("Record", "images/Play24.gif", "record");
        this.button_play = this.createButton("Play", "images/Play24.gif", "play");
        this.button_rewind = this.createButton("Rewind", "images/Rewind24.gif", "rewind");
        this.button_forward = this.createButton("Forward", "images/FastForward24.gif", "forward");
        this.button_stop = this.createButton("Stop", "images/Stop24.gif", "stop");
        this.button_eject = this.createButton("Eject", "images/Eject24.gif", "eject");
        this.save_led = new JLabel(new ImageIcon("images/red-off-16.png"));
        this.motor_led = new JLabel(new ImageIcon("images/green-off-16.png"));
        this.display = new JTextField("Display");
        this.counter = new JTextField("0000");
        this.counter.setFont(new Font(this.display.getFont().getName(), this.display.getFont().getStyle(), this.display.getFont().getSize() * 2));
        JLabel label_save = new JLabel("Save");
        JLabel label_motor = new JLabel("Motor");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.display).addGroup(layout.createSequentialGroup().addComponent(this.button_record).addComponent(this.button_play).addComponent(this.button_rewind).addComponent(this.button_forward).addComponent(this.button_stop).addComponent(this.button_eject))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.counter)).addGroup(layout.createSequentialGroup().addComponent(this.save_led).addComponent(label_save)).addGroup(layout.createSequentialGroup().addComponent(this.motor_led).addComponent(label_motor))));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addGroup(layout.createSequentialGroup().addComponent(this.display).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.button_record).addComponent(this.button_play).addComponent(this.button_rewind).addComponent(this.button_forward).addComponent(this.button_stop).addComponent(this.button_eject))).addGroup(layout.createSequentialGroup().addComponent(this.counter).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.save_led).addComponent(label_save)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.motor_led).addComponent(label_motor)))));
        layout.linkSize(0, this.button_record, this.button_play);
        layout.linkSize(0, this.button_record, this.button_rewind);
        layout.linkSize(0, this.button_record, this.button_forward);
        layout.linkSize(0, this.button_record, this.button_stop);
        layout.linkSize(0, this.button_record, this.button_eject);
    }

    private JButton createButton(String button_text, String button_icon, String button_action) {
        JButton button = new JButton(button_text, new ImageIcon(button_icon));
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setActionCommand(button_action);
        button.addActionListener(this);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("record")) {
            this.state = 2;
            this.updateState();
        } else if (event.getActionCommand().equals("play")) {
            this.state = 1;
            this.updateState();
        } else if (event.getActionCommand().equals("stop")) {
            this.state = 0;
            this.updateState();
        } else if (event.getActionCommand().equals("rewind")) {
            this.tape.rewind();
            this.updateState();
        } else if (event.getActionCommand().equals("forward")) {
            this.tape.forward();
            this.updateState();
        }
    }

    class MotorStateObserver
    implements Observer {
        MotorStateObserver() {
        }

        @Override
        public void update(Observable state, Object motor_state) {
            SwingUtilities.invokeLater(new MotorStateEvent((Boolean)motor_state));
        }

        class MotorStateEvent
        implements Runnable {
            private boolean motor_state;

            public MotorStateEvent(boolean motor_state) {
                this.motor_state = motor_state;
            }

            @Override
            public void run() {
                VicTapePanel.this.motor_on = !this.motor_state;
                VicTapePanel.this.updateState();
            }
        }
    }
}

