/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import emulator.EmulatorConfig;
import emulator.Vc1541Main;
import emulator.VicMain;
import emulator.shell.GUI.util.DialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VicSetupDialog
extends DialogBase {
    static Logger logger = LogManager.getLogger((String)VicSetupDialog.class.getName());
    public static final int VIC20 = 0;
    public static final int VIC1541 = 1;
    private int systemIndex = 0;
    private EmulatorConfig emulatorConfig = new EmulatorConfig();
    private JCheckBox selectIecSimulation;
    private JCheckBox selectFe3Support;
    private JCheckBox selectPortStateLogging;

    public VicSetupDialog(JFrame owner) {
        super(owner, "Setup Emulator", true);
        this.buildContents();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public EmulatorConfig getEmulatorConfig() {
        return this.emulatorConfig;
    }

    public int getSystemIndex() {
        return this.systemIndex;
    }

    private void buildContents() {
        JComboBox<String> selectSystem = new JComboBox<String>(new String[]{"Vic-20", "Vic-1541 (experimental)"});
        selectSystem.addActionListener(new SystemSelectListener());
        selectSystem.setAlignmentX(0.0f);
        selectSystem.setToolTipText("<html><b>Select the system you want to run.</b><br><br><i>Note: VIC-1541 Emulation is experimental and does not emulate the hardware yet</i></html>");
        this.selectPortStateLogging = new JCheckBox("Log port state (slow)");
        this.selectPortStateLogging.setAlignmentX(0.0f);
        this.selectPortStateLogging.setToolTipText("<html><b>Enables logging for VIA I/O</b><br><br>This option enables logging of I/O states for both VIAs and extends the VIA state window by a graph showing the logged values.<br><i>Note: Port state logging slows down emulation by ~25%</i></html>");
        this.selectIecSimulation = new JCheckBox("IEC device simulation");
        this.selectIecSimulation.setAlignmentX(0.0f);
        this.selectIecSimulation.setToolTipText("<html><b>Enables a simple emulation for IEC devices</b><br><br>The IEC simulator emulates the communication protocol of Commodore's serial bus.At present, the emulator supports two devices:<ul><li><i>Printer</i> is like a null device that \"consumes\" every byte and discards it immediately.</li><li><i>Disk</i> is a file system driver that supports reading files (including \"$\") from the local file system.</li></ul></html>");
        this.selectFe3Support = new JCheckBox("FE3 RAM support");
        this.selectFe3Support.setAlignmentX(0.0f);
        this.selectFe3Support.setToolTipText("<html><b>Enables support for the Super RAM mode of the Final Epansion 3</b><br><br>Super RAM mode is fully supported by the emulation. Although the debugger is not aware of the extra RAM,<br>you can always view and edit all RAM Banks of the Final expansion in the memory window.</html>");
        JPanel panelOptions = new JPanel();
        panelOptions.setLayout(new BoxLayout(panelOptions, 3));
        panelOptions.add(selectSystem);
        panelOptions.add(this.selectIecSimulation);
        panelOptions.add(this.selectFe3Support);
        panelOptions.add(this.selectPortStateLogging);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panelOptions, "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
    }

    private void updateDialogState() {
        this.selectIecSimulation.setEnabled(this.systemIndex == 0);
        this.selectFe3Support.setEnabled(this.systemIndex == 0);
    }

    @Override
    protected void closeDialog(boolean result) {
        if (result) {
            this.emulatorConfig.setEnableFe3Support(this.selectFe3Support.isSelected());
            this.emulatorConfig.setEnableIecSimulation(this.selectIecSimulation.isSelected());
            this.emulatorConfig.setEnablePortLogging(this.selectPortStateLogging.isSelected());
        }
        super.closeDialog(result);
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            logger.error("Failed to set system look & feel.", (Throwable)ex);
        }
        VicSetupDialog setupDialog = new VicSetupDialog(null);
        setupDialog.setVisible(true);
        if (setupDialog.getResult()) {
            switch (setupDialog.getSystemIndex()) {
                case 0: {
                    VicMain.runEmulator(args, setupDialog.getEmulatorConfig());
                    break;
                }
                case 1: {
                    Vc1541Main.runEmulator(args, setupDialog.getEmulatorConfig());
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(null, "System configuration " + setupDialog.getSystemIndex() + " is not valid!", "Error running emulator", 0);
                }
            }
        }
    }

    public class SystemSelectListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox selectSystem = (JComboBox)e.getSource();
            VicSetupDialog.this.systemIndex = selectSystem.getSelectedIndex();
            VicSetupDialog.this.updateDialogState();
        }
    }
}

