/*
 * Decompiled with CFR 0.152.
 */
package emulator.analyzer;

import emulator.EmulatorException;
import emulator.analyzer.AddressDefinition;
import emulator.analyzer.util.CmpCommand;
import emulator.analyzer.util.CmpCommandMap;
import emulator.assembler.Assembler;
import emulator.assembler.Instruction;
import emulator.hardware.CPU;
import emulator.hardware.CPUExecutionObserver;
import emulator.hardware.HwWord;
import emulator.hardware.debug.BreakpointException;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.MemoryBlockInterface;
import emulator.util.AddressRange;
import emulator.util.ByteHelper;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class CpuExecutionAnalyzer
implements CPUExecutionObserver {
    PrintStream log = System.out;
    Assembler assembler = new Assembler();
    MemoryBlockInterface memory;
    AddressRange code_range;
    HashMap<Integer, AddressDefinition> address_map = new HashMap();
    HashMap<Character, Integer> reg_defines = new HashMap();
    CmpCommandMap cmp_map = new CmpCommandMap();
    int[] mem_defines;
    boolean allswell;
    private int last_pc = -1;
    private AddressRange dyn_area = null;

    public CpuExecutionAnalyzer(MemoryBlockInterface memory, AddressRange code_range, PrintStream log) {
        this.memory = memory;
        this.code_range = code_range;
        this.log = log;
        this.mem_defines = new int[memory.getData().length];
        Arrays.fill(this.mem_defines, -1);
    }

    @Override
    public void notifyPreExecute(CPU cpu) throws EmulatorException {
        int pc = cpu.getPC();
        if (this.code_range.contains(pc) || this.dyn_area != null && this.dyn_area.contains(pc)) {
            Instruction instruction = this.assembler.getInstruction(this.memory.getData(), pc);
            boolean is_jump = instruction.getOpcode().equals("JMP");
            if (is_jump && instruction.getOperandValue() == pc) {
                int nmi_vec = this.getMemWord(65530);
                int irq_vec = this.getMemWord(65534);
                this.log.println("Endless Loop @$" + new HwWord((long)pc) + " waiting for: NMI@$" + new HwWord((long)nmi_vec) + " IRQ@$" + new HwWord((long)irq_vec));
                this.allswell = false;
                throw new BreakpointException(pc);
            }
            boolean is_indirect = instruction.isIndirectOperand();
            if (instruction.isAddressOperand()) {
                AddressDefinition adrdef = new AddressDefinition();
                adrdef.setFullAddress(instruction.getOperandValue());
                adrdef.setInstruction(instruction);
                adrdef.setType(instruction.getByteCount() > 2 ? 1 : 0);
                adrdef.setInstructionAddress(pc);
                if (!this.address_map.containsKey(pc + 1)) {
                    this.address_map.put(pc + 1, adrdef);
                }
                if (!is_indirect) {
                    boolean bl = is_indirect = this.mem_defines[pc + 1] >= 0 || instruction.getByteCount() > 2 && this.mem_defines[pc + 2] >= 0;
                }
            }
            if (is_indirect) {
                int def_lo;
                int target = instruction.isIndirectOperand() ? instruction.getOperandValue() : pc + 1;
                boolean is_word_address = instruction.isIndirectOperand() || instruction.getByteCount() > 2;
                int ptr_val = this.getMemByte(target);
                if (is_word_address) {
                    ptr_val |= this.getMemByte(target + 1) << 8;
                }
                int n = def_lo = is_jump ? target : this.mem_defines[target];
                if (def_lo >= 0) {
                    AddressDefinition adrdef_lo = new AddressDefinition();
                    adrdef_lo.setFullAddress(ptr_val);
                    adrdef_lo.setInstruction(instruction);
                    adrdef_lo.setType(2);
                    adrdef_lo.setInstructionAddress(pc);
                    this.address_map.put(def_lo, adrdef_lo);
                }
                if (is_word_address) {
                    int def_hi;
                    int n2 = def_hi = is_jump ? target + 1 : this.mem_defines[target + 1];
                    if (def_hi >= 0) {
                        AddressDefinition adrdef_hi = new AddressDefinition();
                        adrdef_hi.setFullAddress(ptr_val);
                        adrdef_hi.setInstruction(instruction);
                        adrdef_hi.setType(3);
                        adrdef_hi.setInstructionAddress(pc);
                        this.address_map.put(def_hi, adrdef_hi);
                    }
                }
            }
            if (instruction.isLoad()) {
                int source_loc;
                int n = source_loc = instruction.isImmediate() ? pc + 1 : instruction.getOperandAddress(cpu);
                if (source_loc >= 0 && this.mem_defines[source_loc] >= 0) {
                    this.reg_defines.put(Character.valueOf(instruction.getStoreLoadReg()), this.mem_defines[source_loc]);
                } else {
                    this.reg_defines.put(Character.valueOf(instruction.getStoreLoadReg()), source_loc);
                }
            } else if (instruction.isStore()) {
                this.mem_defines[instruction.getOperandAddress((CPU)cpu)] = this.reg_defines.get(Character.valueOf(instruction.getStoreLoadReg()));
            } else if (instruction.isTransfer()) {
                this.reg_defines.put(instruction.getTargetReg(), this.reg_defines.get(instruction.getSourceReg()));
            } else if (instruction.isCompare()) {
                int operand_address = instruction.getOperandAddress(cpu);
                int reg_source = this.reg_defines.get(instruction.getCompareReg());
                CmpCommand cmp = new CmpCommand(pc, instruction, operand_address, reg_source, this.getMemByte(operand_address));
                this.cmp_map.add(cmp);
            }
        } else {
            this.allswell = false;
            throw new BusWatchException("PC out of range, last valid was " + new HwWord((long)this.last_pc), new HwWord((long)pc));
        }
        this.last_pc = pc;
    }

    private int getMemWord(int address) {
        return this.getMemByte(address) + (this.getMemByte(address + 1) << 8);
    }

    private int getMemByte(int address) {
        return ByteHelper.byteToInt(this.memory.getData()[address]);
    }

    @Override
    public void notifyPostExecute(CPU cpu) {
    }

    public void dumpStats(PrintStream out, String prefix) {
        out.println(String.valueOf(prefix) + "Relocations:");
        ArrayList<Integer> addresses = new ArrayList<Integer>(this.address_map.keySet());
        Collections.sort(addresses);
        Iterator iterator = addresses.iterator();
        while (iterator.hasNext()) {
            int address = (Integer)iterator.next();
            if (!this.code_range.contains(address)) {
                this.address_map.get(address).print(out, String.valueOf(prefix) + "DYN $" + new HwWord((long)address) + ": ");
            } else {
                this.address_map.get(address).print(out, String.valueOf(prefix) + "$" + new HwWord((long)address) + ": ");
            }
            out.println();
        }
    }

    public HashMap<Integer, AddressDefinition> getAddressMap() {
        return this.address_map;
    }

    public void initRun() {
        this.reg_defines.put(Character.valueOf('A'), -1);
        this.reg_defines.put(Character.valueOf('X'), -1);
        this.reg_defines.put(Character.valueOf('Y'), -1);
        this.reg_defines.put(Character.valueOf('S'), -1);
        this.allswell = true;
        this.last_pc = -1;
    }

    public boolean isOk() {
        return this.allswell;
    }

    public void setDynArea(AddressRange dyn_area) {
        this.dyn_area = dyn_area;
    }

    public int[] getAndClearDynAreaFlow() {
        int[] dyn_defines = new int[this.mem_defines.length];
        Arrays.fill(dyn_defines, -1);
        int i = this.dyn_area.getStart();
        while (i <= this.dyn_area.getEnd()) {
            dyn_defines[i] = this.mem_defines[i];
            this.mem_defines[i] = -1;
            ++i;
        }
        return dyn_defines;
    }

    public AddressRange getCodeRange() {
        return this.code_range;
    }

    public CmpCommandMap getCmpCommandMap() {
        return this.cmp_map;
    }
}

