/*
 * Decompiled with CFR 0.152.
 */
package emulator.analyzer.util;

import emulator.assembler.Instruction;
import emulator.hardware.HwWord;
import java.io.PrintStream;

public class CmpCommand {
    private int location;
    private Instruction instruction;
    private int operand_address;
    private int reg_source;
    private int operand;

    public CmpCommand(int location, Instruction instruction, int operand_address, int reg_source, int op) {
        this.location = location;
        this.instruction = instruction;
        this.operand_address = operand_address;
        this.reg_source = reg_source;
        this.operand = op;
    }

    public void dump(PrintStream out) {
        out.print("@" + new HwWord((long)this.location) + ": " + this.instruction.getOpcode() + " " + this.instruction.getOperand());
        out.print("  ($" + new HwWord((long)this.operand_address) + ") <-> ($" + new HwWord((long)this.reg_source) + ")");
        out.println();
    }

    public int getRegSource() {
        return this.reg_source;
    }

    public int getLocation() {
        return this.location;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public int getOperandAddress() {
        return this.operand_address;
    }

    public int getAddressFromOperand(int value, boolean is_low) {
        int new_value = value & (is_low ? 65280 : 255);
        return new_value | (is_low ? this.operand : this.operand << 8);
    }
}

