/*
 * Decompiled with CFR 0.152.
 */
package emulator.analyzer.util;

import emulator.util.AddressRange;
import java.util.Arrays;

public class StatConverter {
    public static boolean[] notZero(int[] field) {
        boolean[] result = new boolean[field.length];
        int i = 0;
        while (i < field.length) {
            result[i] = field[i] != 0;
            ++i;
        }
        return result;
    }

    public static boolean[] rangeToMask(int start, int end, int length) {
        boolean[] result = new boolean[length];
        Arrays.fill(result, false);
        int i = start;
        while (i <= end) {
            result[i] = true;
            ++i;
        }
        return result;
    }

    public static boolean[] rangeToMask(AddressRange range, int size) {
        return StatConverter.rangeToMask(range.getStart(), range.getEnd(), size);
    }

    public static boolean[] not(boolean[] field) {
        boolean[] result = new boolean[field.length];
        int i = 0;
        while (i < field.length) {
            result[i] = !field[i];
            ++i;
        }
        return result;
    }

    public static boolean[] and(boolean[] field1, boolean[] field2) {
        boolean[] result = new boolean[field1.length];
        int i = 0;
        while (i < field1.length) {
            result[i] = field1[i] && field2[i];
            ++i;
        }
        return result;
    }

    public static boolean[] or(boolean[] field1, boolean[] field2) {
        boolean[] result = new boolean[field1.length];
        int i = 0;
        while (i < field1.length) {
            result[i] = field1[i] || field2[i];
            ++i;
        }
        return result;
    }

    public static int count(boolean[] field) {
        int count = 0;
        int i = 0;
        while (i < field.length) {
            if (field[i]) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int first(boolean[] field) {
        int i = 0;
        while (i < field.length) {
            if (field[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static AddressRange getRangeAt(boolean[] field, int index) {
        int first = index;
        while (first > 0 && field[first - 1]) {
            --first;
        }
        int last = index;
        while (last < field.length - 1 && field[last + 1]) {
            ++last;
        }
        return new AddressRange(first, last);
    }
}

