/*
 * Decompiled with CFR 0.152.
 */
package emulator.assembler;

import emulator.assembler.SymbolTable;
import emulator.hardware.CPU;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.Operand;
import emulator.support.OperandEval;
import emulator.util.ByteHelper;
import emulator.util.MemoryPtr;
import java.io.PrintStream;

public class Instruction {
    private byte[] raw_bytes;
    private String opcode;
    private String operand;
    private OperandEval eval;

    public Instruction(MemoryPtr mem_ref, Command command, Operand operand, SymbolTable symbols) {
        this.opcode = command.getName();
        this.raw_bytes = new byte[1 + operand.getByteCount()];
        mem_ref.get(this.raw_bytes);
        this.operand = operand.getString(mem_ref, symbols);
        this.eval = operand.getEvaluator(mem_ref);
    }

    public Instruction(MemoryPtr mem_ref, int data_length) {
        this.raw_bytes = new byte[data_length];
        mem_ref.get(this.raw_bytes);
        this.opcode = ".by";
        this.operand = this.getBytes();
    }

    public String getBytes() {
        String result = new HwByte((long)this.raw_bytes[0]).toString();
        int i = 1;
        while (i < this.raw_bytes.length) {
            result = String.valueOf(result) + " " + new HwByte((long)this.raw_bytes[i]).toString();
            ++i;
        }
        return result;
    }

    public String getBytesShort() {
        String result = new HwByte((long)this.raw_bytes[0]).toString();
        int max_i = this.raw_bytes.length > 3 ? 2 : this.raw_bytes.length;
        int i = 1;
        while (i < max_i) {
            result = String.valueOf(result) + " " + new HwByte((long)this.raw_bytes[i]).toString();
            ++i;
        }
        if (max_i < this.raw_bytes.length) {
            result = String.valueOf(result) + "...";
        }
        return result;
    }

    public String getOpcode() {
        return this.opcode;
    }

    public String getOperand() {
        return this.operand;
    }

    public int getByteCount() {
        return this.raw_bytes.length;
    }

    public boolean isEnd() {
        return this.opcode.equals("RTS") || this.opcode.equals("JMP") || this.opcode.equals("RTI") || this.opcode.equals("BRK") || this.opcode.equals("ILL");
    }

    public String getOperandDetails(CPU cpu, byte[] memory) {
        if (this.opcode.equals(".by")) {
            return null;
        }
        return this.eval.getDetails(cpu.getCpuState());
    }

    public boolean isAddressOperand() {
        return this.eval.isAddress();
    }

    public boolean isImmediate() {
        return this.operand.startsWith("#");
    }

    public boolean isStore() {
        return this.opcode.equals("STA") || this.opcode.equals("STX") || this.opcode.equals("STY");
    }

    public boolean isLoad() {
        return this.opcode.equals("LDA") || this.opcode.equals("LDX") || this.opcode.equals("LDY");
    }

    public char getStoreLoadReg() {
        return this.opcode.charAt(2);
    }

    public boolean isCompare() {
        return this.opcode.equals("CMP") || this.opcode.equals("CPX") || this.opcode.equals("CPY");
    }

    public int getOperandAddress(CPU cpu) {
        if (this.isImmediate()) {
            return cpu.getPC() + 1;
        }
        return this.eval.getAddress(cpu.getCpuState());
    }

    public boolean isIndirectOperand() {
        return this.eval.isIndirect();
    }

    public int getOperandValue() {
        int result = -1;
        if (this.raw_bytes.length > 1) {
            result = ByteHelper.byteToInt(this.raw_bytes[1]);
            if (this.raw_bytes.length > 2) {
                result += ByteHelper.byteToInt(this.raw_bytes[2]) << 8;
            }
        }
        return result;
    }

    public void print(PrintStream out, String prefix, int address) {
        out.print(this.print(prefix, address));
    }

    public String print(String prefix, int address) {
        return String.valueOf(prefix) + "$" + new HwWord((long)address) + String.format(": %-10s ", this.getBytes()) + this.getOpcode() + " " + this.getOperand();
    }

    public boolean isTransfer() {
        return this.opcode.startsWith("T");
    }

    public Character getTargetReg() {
        return Character.valueOf(this.opcode.charAt(2));
    }

    public Character getSourceReg() {
        return Character.valueOf(this.opcode.charAt(1));
    }

    public Character getCompareReg() {
        return Character.valueOf(this.getTargetReg().charValue() == 'P' ? (char)'A' : this.getTargetReg().charValue());
    }
}

