/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.bus;

import emulator.hardware.bus.Bus;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.io.Via6522;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.memory.UnmappedMemoryException;

public class FloppyBus
implements Bus {
    private MemoryBlock memory;
    private Via6522 via1;
    private Via6522 via2;

    public FloppyBus(MemoryBlock memory, Via6522 via1, Via6522 via2) {
        this.memory = memory;
        this.via1 = via1;
        this.via2 = via2;
    }

    @Override
    public void write(int address, int data) throws BusWatchException, UnmappedMemoryException {
        if (address < 2048) {
            this.memory.write(address, data);
        } else if (address < 49152) {
            if (6144 <= address && address < 6160) {
                this.via1.write(address & 0xF, data);
            } else if (7168 <= address && address < 7184) {
                this.via2.write(address & 0xF, data);
            }
        }
    }

    @Override
    public int read(int address) throws BusWatchException, UnmappedMemoryException {
        if (address < 2048 || address >= 49152) {
            return this.memory.read(address);
        }
        if (6144 <= address && address < 6160) {
            return this.via1.read(address & 0xF);
        }
        if (7168 <= address && address < 7184) {
            return this.via2.read(address & 0xF);
        }
        return address >> 8 & 0xFF;
    }
}

