/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.clock;

import emulator.hardware.clock.ClockHandle;
import emulator.hardware.clock.ClockImpl2;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClockHandleImpl2
implements ClockHandle {
    static Logger logger = LogManager.getLogger((String)ClockHandleImpl2.class.getName());
    private int ticks_avail = 0;
    private ClockImpl2 clock = null;
    private long ticks_elapsed = 0L;

    ClockHandleImpl2(ClockImpl2 clock) {
        this.clock = clock;
    }

    public synchronized boolean grantTicks(int ticks_granted) {
        this.ticks_avail += ticks_granted;
        if (this.ticks_avail > 0) {
            this.notify();
            return true;
        }
        return false;
    }

    private synchronized void consumeTicks(int ticks_consumed) {
        this.ticks_avail -= ticks_consumed;
        this.ticks_elapsed += (long)ticks_consumed;
    }

    private synchronized void waitTicksAvail() {
        while (this.ticks_avail <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                logger.warn("Waiting for ticks was interrupted", (Throwable)ex);
            }
        }
    }

    private synchronized boolean areTicksAvailable() {
        return this.ticks_avail > 0;
    }

    @Override
    public void tick() {
        this.tick(1);
    }

    @Override
    public void tick(int ticks_consumed) {
        this.consumeTicks(ticks_consumed);
        if (!this.areTicksAvailable()) {
            this.clock.requestTicks(this);
            this.waitTicksAvail();
        }
    }

    @Override
    public long getTicks() {
        return this.ticks_elapsed;
    }
}

