/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.clock;

public class TickHelper {
    private long[] handle_ticks = null;
    private int act_handles = 0;
    private long min_ticks = 0L;
    private long max_ticks = 0L;

    public TickHelper(long[] handle_ticks, int act_handles) {
        this.handle_ticks = handle_ticks;
        this.act_handles = act_handles;
        this.calcMinMax();
    }

    public void calcMinMax() {
        this.min_ticks = Long.MAX_VALUE;
        this.max_ticks = Long.MIN_VALUE;
        int i = 0;
        while (i < this.act_handles) {
            if (this.handle_ticks[i] >= 0L) {
                if (this.handle_ticks[i] < this.min_ticks) {
                    this.min_ticks = this.handle_ticks[i];
                }
                if (this.handle_ticks[i] > this.max_ticks) {
                    this.max_ticks = this.handle_ticks[i];
                }
            }
            ++i;
        }
    }

    public long getMin() {
        return this.min_ticks;
    }

    public long getMax() {
        return this.max_ticks;
    }

    public void rebaseTicks() {
        int i = 0;
        while (i < this.act_handles) {
            if (this.handle_ticks[i] >= 0L) {
                int n = i;
                this.handle_ticks[n] = this.handle_ticks[n] - this.min_ticks;
            }
            ++i;
        }
        this.max_ticks -= this.min_ticks;
        this.min_ticks = 0L;
    }

    public void setHandleCount(int act_handles) {
        this.act_handles = act_handles;
    }
}

