/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.debug;

import emulator.hardware.CPU;
import emulator.hardware.CPUExecutionObserver;
import emulator.hardware.debug.AddressStatistics;
import emulator.hardware.debug.profiling.CallGraph;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.stack.CpuStack;
import java.util.Observable;
import java.util.Observer;

public class CpuProfiler
extends Observable
implements CPUExecutionObserver {
    private AddressStatistics[] statistics;
    private int current_address = -1;
    private long last_cycle_count = -1L;
    private int last_stack_event = 0;
    private StackObserver stackObserver = new StackObserver();
    private CallGraph callGraph = new CallGraph();

    public CpuProfiler(int address_range) {
        this.statistics = new AddressStatistics[address_range];
        int i = 0;
        while (i < address_range) {
            this.statistics[i] = new AddressStatistics(i);
            ++i;
        }
    }

    public void reset() {
        AddressStatistics[] addressStatisticsArray = this.statistics;
        int n = this.statistics.length;
        int n2 = 0;
        while (n2 < n) {
            AddressStatistics s = addressStatisticsArray[n2];
            s.reset();
            ++n2;
        }
        this.callGraph.init();
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void notifyPreExecute(CPU cpu) {
        this.current_address = cpu.getPC();
        this.last_cycle_count = cpu.getTicks();
        this.last_stack_event = 0;
    }

    @Override
    public void notifyPostExecute(CPU cpu) {
        assert (this.current_address >= 0);
        assert (this.last_cycle_count >= 0L);
        this.statistics[this.current_address].countExecution((int)(cpu.getTicks() - this.last_cycle_count));
        if (this.last_stack_event > 0) {
            if (this.last_stack_event == CpuStack.PUSH_ADDRESS_EVENT) {
                this.callGraph.handleCall(this.current_address, cpu.getPC(), cpu.getTicks());
            } else if (this.last_stack_event == CpuStack.POP_ADDRESS_EVENT) {
                this.callGraph.handleReturn(this.current_address, cpu.getPC(), cpu.getTicks());
            }
        }
        this.current_address = -1;
        this.last_cycle_count = -1L;
    }

    public AddressStatistics getStatisticsForAddress(int address) {
        return this.statistics[address];
    }

    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    public void enable(Cpu6502 cpu, boolean enable) {
        if (enable) {
            this.callGraph.start(cpu.getPC(), cpu.getTicks());
            cpu.setExecutionObserver(this);
            cpu.getStack().addObserver(this.stackObserver);
        } else {
            cpu.getStack().deleteObserver(this.stackObserver);
            cpu.setExecutionObserver(null);
        }
    }

    public class StackObserver
    implements Observer {
        @Override
        public void update(Observable o, Object arg) {
            if (arg == CpuStack.POP_ADDRESS_EVENT) {
                CpuProfiler.this.last_stack_event = CpuStack.POP_ADDRESS_EVENT;
            } else if (arg == CpuStack.PUSH_ADDRESS_EVENT) {
                CpuProfiler.this.last_stack_event = CpuStack.PUSH_ADDRESS_EVENT;
            }
        }
    }
}

