/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.debug.profiling;

import emulator.hardware.debug.profiling.CodeSegment;

public class ActiveCode {
    private CodeSegment codeSegment;
    private long ticksStart;

    public ActiveCode(CodeSegment codeSegment) {
        this.codeSegment = codeSegment;
    }

    public ActiveCode enter(long ticksStart) {
        this.ticksStart = ticksStart;
        return this;
    }

    public long leave(long ticksEnd, int exitAddress) {
        long ticks = ticksEnd - this.ticksStart;
        this.codeSegment.incCallCount();
        this.codeSegment.addTicks(ticks);
        this.codeSegment.addExitAddress(exitAddress);
        return ticks;
    }

    public void addChild(CodeSegment nextSegment) {
        this.codeSegment.addChild(nextSegment);
    }

    public void addSubTicks(long ticks) {
        this.codeSegment.addSubTicks(ticks);
    }
}

