/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.debug.profiling;

import emulator.hardware.debug.profiling.ActiveCode;
import emulator.hardware.debug.profiling.CodeSegment;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class CallGraph {
    private Stack<ActiveCode> callStack;
    private Map<Integer, CodeSegment> codeMap;
    private Set<CodeSegment> topLevelSegments;

    public void init() {
        this.codeMap = new HashMap<Integer, CodeSegment>();
        this.topLevelSegments = new LinkedHashSet<CodeSegment>();
    }

    public void start(int currentPc, long currentTicks) {
        CodeSegment rootSegment = this.fetchCodeSegment(currentPc);
        this.codeMap.put(rootSegment.getEnterAddress(), rootSegment);
        this.callStack = new Stack();
        this.callStack.push(new ActiveCode(rootSegment).enter(currentTicks));
        this.topLevelSegments.add(rootSegment);
    }

    public void handleCall(int lastPC, int currentPc, long currentTicks) {
        CodeSegment nextSegment = this.fetchCodeSegment(currentPc);
        if (!this.callStack.empty()) {
            this.callStack.peek().addChild(nextSegment);
        } else {
            this.topLevelSegments.add(nextSegment);
        }
        this.callStack.push(new ActiveCode(nextSegment).enter(currentTicks));
    }

    public void handleReturn(int lastPC, int currentPc, long currentTicks) {
        if (!this.callStack.empty()) {
            ActiveCode code = this.callStack.pop();
            long ticks = code.leave(currentTicks, currentPc);
            if (!this.callStack.empty()) {
                this.callStack.peek().addSubTicks(ticks);
            }
        }
    }

    public Collection<CodeSegment> getCodeSegments() {
        return this.codeMap.values();
    }

    private CodeSegment fetchCodeSegment(int enterAddress) {
        CodeSegment segment = this.codeMap.get(enterAddress);
        if (segment == null) {
            segment = new CodeSegment(enterAddress);
            this.codeMap.put(segment.getEnterAddress(), segment);
        }
        return segment;
    }

    public Collection<CodeSegment> getTopLevelSegments() {
        return this.topLevelSegments;
    }
}

