/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.debug.profiling;

import java.util.LinkedHashSet;
import java.util.Set;

public class CodeSegment
implements Comparable<CodeSegment> {
    private int enterAddress;
    private int callCount;
    private long sumTicks;
    private long subTicks;
    private Set<Integer> exitAddresses = new LinkedHashSet<Integer>();
    private Set<CodeSegment> children = new LinkedHashSet<CodeSegment>();

    public CodeSegment(int enterAddress) {
        this.enterAddress = enterAddress;
        this.callCount = 0;
        this.sumTicks = 0L;
        this.subTicks = 0L;
    }

    public int getEnterAddress() {
        return this.enterAddress;
    }

    public int getCallCount() {
        return this.callCount;
    }

    public void incCallCount() {
        ++this.callCount;
    }

    public long getSumTicks() {
        return this.sumTicks;
    }

    public void addTicks(long ticks) {
        this.sumTicks += ticks;
    }

    public long getSubTicks() {
        return this.subTicks;
    }

    public void addSubTicks(long ticks) {
        this.subTicks += ticks;
    }

    public Set<Integer> getExitAddresses() {
        return this.exitAddresses;
    }

    public void addExitAddress(int exitAddress) {
        this.exitAddresses.add(exitAddress);
    }

    public Set<CodeSegment> getChildren() {
        return this.children;
    }

    public void addChild(CodeSegment child) {
        this.children.add(child);
    }

    public int hashCode() {
        return this.enterAddress;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            return this.enterAddress == ((CodeSegment)obj).enterAddress;
        }
        return false;
    }

    @Override
    public int compareTo(CodeSegment o) {
        return this.enterAddress - o.enterAddress;
    }
}

