/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io;

import emulator.hardware.HwByte;
import emulator.hardware.bits.SharedBit;
import emulator.hardware.bus.Bus;
import emulator.hardware.clock.Clock;
import emulator.hardware.clock.ClockHandle;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.io.AuxiliaryControlRegister;
import emulator.hardware.io.Counter;
import emulator.hardware.io.Port6522;
import emulator.hardware.io.PortControlRegister;
import emulator.hardware.io.Register6522;
import emulator.hardware.io.registers6522.ACR;
import emulator.hardware.io.registers6522.DDRA;
import emulator.hardware.io.registers6522.DDRB;
import emulator.hardware.io.registers6522.IER;
import emulator.hardware.io.registers6522.IFR;
import emulator.hardware.io.registers6522.ORA;
import emulator.hardware.io.registers6522.ORA2;
import emulator.hardware.io.registers6522.ORB;
import emulator.hardware.io.registers6522.PCR;
import emulator.hardware.io.registers6522.SR;
import emulator.hardware.io.registers6522.T1CH;
import emulator.hardware.io.registers6522.T1CL;
import emulator.hardware.io.registers6522.T1LH;
import emulator.hardware.io.registers6522.T1LL;
import emulator.hardware.io.registers6522.T2CH;
import emulator.hardware.io.registers6522.T2CL;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.util.TickWorker;

public class Via6522
extends Thread
implements Bus,
TickWorker {
    private Register6522[] registers = new Register6522[16];
    private ClockHandle clock = null;
    private SharedBit irq_out;
    private Port6522 portA = new Port6522();
    private Port6522 portB = new Port6522();
    private Counter timer1 = new Counter();
    private Counter timer2 = new Counter();
    private HwByte interrupt_flags = new HwByte();
    private HwByte interrupt_mask = new HwByte();
    private int timer1_latch = 0;
    private int timer2_latch = 0;
    private int shift_register = 0;
    private AuxiliaryControlRegister aux_control = new AuxiliaryControlRegister();
    private PortControlRegister port_control = new PortControlRegister();
    private boolean timer1_set = false;
    private boolean timer2_set = false;
    private boolean last_ca1 = false;
    private boolean last_ca2 = false;
    private boolean last_cb1 = false;
    private boolean last_cb2 = false;

    public Via6522() {
        this.registers[0] = new ORB();
        this.registers[1] = new ORA();
        this.registers[2] = new DDRB();
        this.registers[3] = new DDRA();
        this.registers[4] = new T1CL();
        this.registers[5] = new T1CH();
        this.registers[6] = new T1LL();
        this.registers[7] = new T1LH();
        this.registers[8] = new T2CL();
        this.registers[9] = new T2CH();
        this.registers[10] = new SR();
        this.registers[11] = new ACR();
        this.registers[12] = new PCR();
        this.registers[13] = new IFR();
        this.registers[14] = new IER();
        this.registers[15] = new ORA2();
    }

    public void attach(Clock clock, SharedBit irq_out) {
        if (clock != null) {
            this.clock = clock.acquireHandle();
        }
        this.irq_out = irq_out;
    }

    public void detach() {
        this.clock = null;
    }

    @Override
    public void run() {
        while (true) {
            this.clock.tick();
            this.runTick();
        }
    }

    @Override
    public synchronized void runTick() {
        this.handleTimer1();
        this.handleTimer2();
        this.handlePortA();
        this.handlePortB();
        this.evaluateInterrupts();
        this.irq_out.setValue(!this.interrupt_flags.getBit(7));
    }

    private void handleTimer1() {
        if (this.timer1.countDown() == 0) {
            this.timer1.load(this.timer1_latch);
            if ((this.aux_control.getTimer1Mode() & 1) == 0) {
                if (this.timer1_set) {
                    this.interrupt_flags.setBit(6, true);
                    this.timer1_set = false;
                    if ((this.aux_control.getTimer1Mode() & 2) != 0) {
                        this.portB.getOutPortBit(7).setValue(true);
                    }
                }
            } else {
                this.interrupt_flags.setBit(6, true);
                if ((this.aux_control.getTimer1Mode() & 2) != 0) {
                    this.portB.getOutPortBit(7).toggle();
                }
            }
        }
    }

    private void startTimer1() {
        this.timer1.load(this.timer1_latch);
        this.timer1_set = true;
        if (this.aux_control.getTimer1Mode() == 2) {
            this.portB.getOutPortBit(7).setValue(false);
        }
    }

    private void handleTimer2() {
        int count = 1;
        if (!this.aux_control.getTimer2Mode()) {
            count = this.timer2.countDown();
        }
        if (count == 0) {
            this.timer2.load(this.timer2_latch);
            if (this.timer2_set) {
                this.interrupt_flags.setBit(5, true);
                this.timer2_set = false;
            }
        }
    }

    private void startTimer2() {
        this.timer2.load(this.timer2_latch);
        this.timer2_set = true;
    }

    private void handlePortA() {
        this.evaluatePort(this.portA, this.port_control.getIrq0Mode(), this.port_control.getIrq1Mode(), 0, 1, this.last_ca1, this.last_ca2);
        this.last_ca1 = this.portA.getControlBit(0).getValue();
        this.last_ca2 = this.portA.getControlBit(1).getValue();
    }

    private void handlePortB() {
        this.evaluatePort(this.portB, this.port_control.getIrq3Mode(), this.port_control.getIrq4Mode(), 3, 4, this.last_cb1, this.last_cb2);
        this.last_cb1 = this.portB.getControlBit(0).getValue();
        this.last_cb2 = this.portB.getControlBit(1).getValue();
    }

    private void evaluatePort(Port6522 port, int irq0_mode, boolean irq1_mode, int irq0_bit, int irq1_bit, boolean last_ctrl1, boolean last_ctrl2) {
        port.pre();
        boolean ctrl1 = port.getControlBit(0).getValue();
        boolean ctrl2 = port.getControlBit(1).getValue();
        boolean ctrl1_changed = ctrl1 ^ last_ctrl1;
        boolean ctrl2_changed = ctrl2 ^ last_ctrl2;
        if (ctrl1_changed && ctrl1 == irq1_mode) {
            this.interrupt_flags.setBit(irq1_bit, true);
        }
        switch (irq0_mode) {
            case 0: {
                if (!ctrl2_changed || ctrl2) break;
                this.interrupt_flags.setBit(irq0_bit, true);
                break;
            }
            case 1: {
                if (!ctrl2_changed || ctrl2) break;
                this.interrupt_flags.setBit(irq0_bit, true);
                break;
            }
            case 2: {
                if (!ctrl2_changed || !ctrl2) break;
                this.interrupt_flags.setBit(irq0_bit, true);
                break;
            }
            case 3: {
                if (!ctrl2_changed || !ctrl2) break;
                this.interrupt_flags.setBit(irq0_bit, true);
                break;
            }
            case 4: {
                if (!ctrl1_changed || !ctrl1 || ctrl2) break;
                port.getControlBit(1).setValue(true);
                break;
            }
            case 5: {
                if (ctrl2_changed || ctrl2) break;
                port.getControlBit(1).setValue(true);
                break;
            }
            case 6: {
                port.getControlBit(1).setValue(false);
                break;
            }
            case 7: {
                port.getControlBit(1).setValue(true);
            }
        }
        port.post();
    }

    @Override
    public synchronized int read(int address) throws BusWatchException, UnmappedMemoryException {
        return this.registers[address & 0xF].read(this);
    }

    @Override
    public synchronized void write(int address, int data) throws BusWatchException, UnmappedMemoryException {
        this.registers[address & 0xF].write(this, data & 0xFF);
    }

    private void evaluateInterrupts() {
        boolean interrupt_pending = (this.interrupt_flags.getNumber() & this.interrupt_mask.getNumber() & 0x7FL) > 0L;
        this.interrupt_flags.setBit(7, interrupt_pending);
    }

    public int readORB() {
        this.resetPortBInterrupt();
        return this.portB.readPort();
    }

    public void writeORB(int value) {
        this.portB.writePort(value);
        this.resetPortBInterrupt();
    }

    private void resetPortBInterrupt() {
        this.interrupt_flags.setBit(3, false);
        this.interrupt_flags.setBit(4, false);
    }

    public int readORA() {
        this.resetPortAInterrupt();
        return this.portA.readPort();
    }

    public void writeORA(int value) {
        this.portA.writePort(value);
        this.resetPortAInterrupt();
    }

    private void resetPortAInterrupt() {
        this.interrupt_flags.setBit(0, false);
        this.interrupt_flags.setBit(1, false);
    }

    public int readDDRB() {
        return this.portB.getPortMask();
    }

    public void writeDDRB(int value) {
        this.portB.setPortMask(value);
    }

    public int readDDRA() {
        return this.portA.getPortMask();
    }

    public void writeDDRA(int value) {
        this.portA.setPortMask(value);
    }

    public int readT1CL() {
        this.interrupt_flags.setBit(6, false);
        return this.timer1.getValue() & 0xFF;
    }

    public void writeT1CL(int value) {
        this.timer1_latch = this.timer1_latch & 0xFF00 | value;
    }

    public int readT1CH() {
        return this.timer1.getValue() >> 8 & 0xFF;
    }

    public void writeT1CH(int value) {
        this.timer1_latch = this.timer1_latch & 0xFF | value << 8;
        this.interrupt_flags.setBit(6, false);
        this.startTimer1();
    }

    public int readT1LL() {
        return this.timer1_latch & 0xFF;
    }

    public void writeT1LL(int value) {
        this.timer1_latch = this.timer1_latch & 0xFF00 | value;
    }

    public int readT1LH() {
        return this.timer1_latch >> 8 & 0xFF;
    }

    public void writeT1LH(int value) {
        this.timer1_latch = this.timer1_latch & 0xFF | value << 8;
    }

    public int readT2CL() {
        this.interrupt_flags.setBit(5, false);
        return this.timer2.getValue() & 0xFF;
    }

    public void writeT2CL(int value) {
        this.timer2_latch = this.timer2_latch & 0xFF00 | value;
    }

    public int readT2CH() {
        return this.timer2.getValue() >> 8 & 0xFF;
    }

    public void writeT2CH(int value) {
        this.timer2_latch = this.timer2_latch & 0xFF | value << 8;
        this.interrupt_flags.setBit(5, false);
        this.startTimer2();
    }

    public int readSR() {
        this.interrupt_flags.setBit(2, false);
        return this.shift_register;
    }

    public void writeSR(int value) {
        this.interrupt_flags.setBit(2, false);
        this.shift_register = value;
    }

    public int readACR() {
        return this.aux_control.getValue();
    }

    public void writeACR(int value) {
        this.aux_control.setValue(value);
    }

    public int readPCR() {
        return this.port_control.getValue();
    }

    public void writePCR(int value) {
        this.port_control.setValue(value);
    }

    public int readIFR() {
        return (int)this.interrupt_flags.getNumber();
    }

    public void writeIFR(int value) {
        int i = 0;
        while (i < 7) {
            if ((value & 1 << i) != 0) {
                this.interrupt_flags.setBit(i, false);
            }
            ++i;
        }
        this.evaluateInterrupts();
    }

    public int readIER() {
        return (int)(this.interrupt_mask.getNumber() | 0x80L);
    }

    public void writeIER(int value) {
        int i = 0;
        while (i < 7) {
            if ((value & 1 << i) != 0) {
                this.interrupt_mask.setBit(i, (value & 0x80) != 0);
            }
            ++i;
        }
    }

    public int readORA2() {
        return this.portA.readPort();
    }

    public void writeORA2(int value) {
        this.portA.writePort(value);
    }

    public Port6522 getPortB() {
        return this.portB;
    }

    public Port6522 getPortA() {
        return this.portA;
    }

    public int getTimer1Latch() {
        return this.timer1_latch;
    }

    public int getTimer1Counter() {
        return this.timer1.getValue();
    }

    public int getTimer1Mode() {
        return this.aux_control.getTimer1Mode();
    }

    public int getTimer2Latch() {
        return this.timer2_latch;
    }

    public int getTimer2Counter() {
        return this.timer2.getValue();
    }

    public int getTimer2Mode() {
        return this.aux_control.getTimer2Mode() ? 1 : 0;
    }

    public int getShiftRegister() {
        return this.shift_register;
    }

    public int getShiftMode() {
        return this.aux_control.getShiftMode();
    }

    public int getCA1Mode() {
        return this.port_control.getIrq1Mode() ? 1 : 0;
    }

    public int getCA2Mode() {
        return this.port_control.getIrq0Mode();
    }

    public int getCB1Mode() {
        return this.port_control.getIrq4Mode() ? 1 : 0;
    }

    public int getCB2Mode() {
        return this.port_control.getIrq3Mode();
    }

    public long getTicks() {
        return this.clock.getTicks();
    }

    @Override
    public void setClock(ClockHandle clock) {
        this.clock = clock;
    }
}

