/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals;

import emulator.hardware.bits.SharedBit;
import emulator.hardware.io.Via6522;
import emulator.hardware.io.peripherals.JoystickButton;
import java.util.Observable;

public class Joystick
extends Observable {
    SharedBit[] button_state = new SharedBit[5];
    JoystickButton[] button = new JoystickButton[5];
    public static final int BUTTON_FIRE = 1;
    public static final int BUTTON_LEFT = 2;
    public static final int BUTTON_RIGHT = 4;
    public static final int BUTTON_UP = 8;
    public static final int BUTTON_DOWN = 16;

    public JoystickButton getButton(int index) {
        return this.button[index];
    }

    public void attachToVia(Via6522 via_keyboard, Via6522 via_joystick) {
        this.button_state[0] = via_joystick.getPortA().getInPortBit(5);
        this.button_state[1] = via_joystick.getPortA().getInPortBit(4);
        this.button_state[2] = via_keyboard.getPortB().getInPortBit(7);
        this.button_state[3] = via_joystick.getPortA().getInPortBit(2);
        this.button_state[4] = via_joystick.getPortA().getInPortBit(3);
        int i = 0;
        while (i < this.button.length) {
            this.button_state[i].setValue(true);
            this.button[i] = new JoystickButton(i, this);
            ++i;
        }
    }

    public void updatePosition(int direction) {
        int i = 0;
        while (i < this.button_state.length) {
            this.button_state[i].setValue((direction & 1 << i) != 0);
            ++i;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void updateButton(int index, boolean value) {
        this.button_state[index].setValue(value);
        this.setChanged();
        this.notifyObservers();
    }

    public boolean getState(int index) {
        return this.button_state[index].getValue();
    }
}

