/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals;

import emulator.hardware.bits.SharedBit;
import emulator.hardware.io.Port6522;
import emulator.hardware.io.Port6522Listener;
import emulator.hardware.io.Via6522;
import emulator.hardware.io.peripherals.VicTapeState;
import java.util.Observable;
import java.util.Observer;

public class VicTape {
    private VicTapeState tape_state;
    private SharedBit motor_out;
    private SharedBit switch_in;
    private boolean do_record = false;
    private long clocks_per_sec = 1108404L;

    public void attachToVia(Via6522 via_keyboard, Via6522 via_joystick) {
        this.tape_state = new VicTapeState();
        this.motor_out = via_joystick.getPortA().getControlBit(1);
        this.switch_in = via_joystick.getPortA().getInPortBit(6);
        via_keyboard.getPortA().addPortListener(new CassetteReadListener());
        via_keyboard.getPortB().addPortListener(new CassetteWriteListener());
        this.addMotorObserver(new MotorStateObserver());
    }

    public void setSwitch(boolean enable, boolean do_record) {
        this.switch_in.setValue(enable);
        this.do_record = do_record;
        this.updateState();
    }

    public void addMotorObserver(Observer o) {
        this.motor_out.addObserver(o);
    }

    public void rewind() {
        this.tape_state.getContents().rewind();
    }

    public void forward() {
        this.tape_state.getContents().forward();
    }

    public int getCurrentTrack() {
        return this.tape_state.getContents().getCurrentIndex();
    }

    public int getTrackCount() {
        return this.tape_state.getContents().getTrackCount();
    }

    public String getCurrentLength() {
        long ms = this.tape_state.getContents().getCurrentTrack().getCount() / (1000L * this.clocks_per_sec);
        long secs = ms / 1000L;
        long minutes = secs / 60L;
        String min_str = "00" + Long.toString(minutes);
        min_str = min_str.substring(min_str.length() - 2);
        String sec_str = "00" + Long.toString(secs %= 60L);
        sec_str = sec_str.substring(sec_str.length() - 2);
        String ms_str = "000" + Long.toString(ms %= 1000L);
        ms_str = ms_str.substring(ms_str.length() - 3);
        return String.valueOf(min_str) + ":" + sec_str + "." + ms_str;
    }

    private void updateState() {
        boolean tape_running;
        boolean bl = tape_running = !this.motor_out.getValue() && !this.switch_in.getValue();
        if (tape_running) {
            if (this.do_record) {
                this.tape_state.handleRecordEvent();
            } else {
                this.tape_state.handlePlayEvent();
            }
        } else {
            this.tape_state.handleStopEvent();
        }
    }

    class CassetteReadListener
    implements Port6522Listener {
        CassetteReadListener() {
        }

        @Override
        public void handlePre(Port6522 port) {
            port.getControlBit(0).setValue(VicTape.this.tape_state.performPreReadEvent(port.getControlBit(0).getValue()));
        }

        @Override
        public void handlePost(Port6522 port) {
            port.getControlBit(0).setValue(VicTape.this.tape_state.performPostReadEvent(port.getControlBit(0).getValue()));
        }
    }

    class CassetteWriteListener
    implements Port6522Listener {
        CassetteWriteListener() {
        }

        @Override
        public void handlePre(Port6522 port) {
            port.getOutPortBit(3).setValue(VicTape.this.tape_state.performPreWriteEvent(port.getOutPortBit(3).getValue()));
        }

        @Override
        public void handlePost(Port6522 port) {
            port.getOutPortBit(3).setValue(VicTape.this.tape_state.performPostWriteEvent(port.getOutPortBit(3).getValue()));
        }
    }

    class MotorStateObserver
    implements Observer {
        MotorStateObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            VicTape.this.updateState();
        }
    }
}

