/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals.iec;

import java.util.Observable;

public class DeviceInfo
extends Observable {
    public static final int DISK = 0;
    public static final int PRINTER = 1;
    private static final String[] device_types = new String[]{"disk", "printer"};
    private boolean is_enabled = false;
    private int address = 0;
    private String type = "";
    private String file = "";

    public DeviceInfo(int address, String type, String file) {
        this.address = address;
        this.type = type;
        this.file = file;
        this.is_enabled = true;
    }

    public DeviceInfo(int address, int type, String file) {
        this.address = address;
        this.type = device_types[type];
        this.file = file;
        this.is_enabled = true;
    }

    public static String[] getDeviceTypes() {
        return device_types;
    }

    public void setEnabled(boolean is_enabled) {
        this.is_enabled = is_enabled;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isEnabled() {
        return this.is_enabled;
    }

    public void setAddress(int address) {
        this.address = address;
        this.setChanged();
        this.notifyObservers();
    }

    public int getAddress() {
        return this.address;
    }

    public void setType(String type) {
        this.type = type;
        this.setChanged();
        this.notifyObservers();
    }

    public String getType() {
        return this.type;
    }

    public void setFile(String file) {
        this.file = file;
        this.setChanged();
        this.notifyObservers();
    }

    public String getFile() {
        return this.file;
    }

    public static DeviceInfo fromConfig(String device_config) {
        String[] parts = device_config.split(",");
        if (parts.length >= 4) {
            int address = Integer.parseInt(parts[0]);
            DeviceInfo info = new DeviceInfo(address, parts[1], parts[2]);
            info.is_enabled = parts[3].equalsIgnoreCase("active");
            return info;
        }
        return null;
    }

    public String toConfig() {
        return String.valueOf(this.address) + "," + this.type + "," + this.file + "," + (this.is_enabled ? "active" : "inactive");
    }
}

