/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals.iec;

import emulator.hardware.io.peripherals.iec.DriveStatus;
import emulator.hardware.io.peripherals.iec.FsDirectory;
import emulator.hardware.io.peripherals.iec.FsDriverChannel;
import emulator.hardware.io.peripherals.iec.IecSimFsDriver;
import emulator.util.ByteBufferReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FsDriverFileChannel
implements FsDriverChannel {
    static Logger logger = LogManager.getLogger((String)FsDriverFileChannel.class.getName());
    private static final int MAX_FILE_BUF = 65535;
    FsDirectory directory = null;
    DriveStatus drive_status = null;
    ByteBuffer buffer = null;

    public FsDriverFileChannel(IecSimFsDriver driver) {
        this.drive_status = driver.getDriveStatus();
        this.directory = driver.getDirectory();
    }

    @Override
    public void open(String name) {
        logger.info("open file \"" + name + "\" for channel " + this);
        if (this.directory == null) {
            this.drive_status.setStatus(74, 0, 0);
        } else if (name.equals("$")) {
            this.buffer = ByteBuffer.allocate(65535);
            this.buffer.clear();
            this.directory.getDirectory(this.buffer);
            this.buffer.flip();
            this.drive_status.setStatus(0, 0, 0);
        } else {
            String file_path = this.directory.getFilePath(name);
            if (file_path != null) {
                try {
                    FileInputStream file = new FileInputStream(file_path);
                    if (file != null) {
                        this.buffer = ByteBuffer.allocate(65535);
                        this.buffer.clear();
                        file.getChannel().read(this.buffer);
                        this.buffer.flip();
                        this.drive_status.setStatus(0, 0, 0);
                        return;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException e) {
                    this.drive_status.setStatus(21, 0, 0);
                }
            }
            this.drive_status.setStatus(62, 0, 0);
        }
    }

    @Override
    public void close() {
        this.buffer = null;
    }

    @Override
    public void write(ByteBuffer data) {
        while (data.hasRemaining()) {
            data.get();
        }
    }

    @Override
    public int read() {
        if (this.buffer != null && this.buffer.hasRemaining()) {
            return ByteBufferReader.getByte(this.buffer);
        }
        return -1;
    }

    @Override
    public void rewind(int offset) {
        if (this.buffer != null) {
            this.buffer.position(this.buffer.position() - offset);
        }
    }
}

