/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals.iec;

import emulator.hardware.io.peripherals.iec.DeviceInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.prefs.Preferences;

public class IecSimDeviceRegistry
extends Observable
implements Observer {
    private Map<Integer, DeviceInfo> device_map = null;
    private static IecSimDeviceRegistry instance = new IecSimDeviceRegistry();
    private Preferences cfg = Preferences.userNodeForPackage(this.getClass());

    private IecSimDeviceRegistry() {
        this.loadConfiguration();
    }

    public static IecSimDeviceRegistry instance() {
        return instance;
    }

    public void loadConfiguration() {
        this.device_map = new HashMap<Integer, DeviceInfo>();
        String device_list = this.cfg.get("iec_devices", "?");
        if (device_list.equals("?")) {
            this.addDeviceInt(new DeviceInfo(4, 1, "(null)"));
            this.addDeviceInt(new DeviceInfo(8, 0, "."));
        } else {
            String[] devices = device_list.split(",");
            int i = 0;
            while (i < devices.length) {
                String device_config;
                DeviceInfo device;
                if (devices[i].length() > 0 && (device = DeviceInfo.fromConfig(device_config = this.cfg.get("iec_device_" + devices[i], ""))) != null && !this.device_map.containsKey(device.getAddress())) {
                    this.addDeviceInt(device);
                }
                ++i;
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void saveConfiguration() {
        String device_list = "";
        for (DeviceInfo device : this.device_map.values()) {
            String dev_key = "" + device.getAddress();
            this.cfg.put("iec_device_" + dev_key, device.toConfig());
            device_list = String.valueOf(device_list) + dev_key + ",";
        }
        this.cfg.put("iec_devices", device_list);
    }

    public void addDevice(DeviceInfo device) {
        this.addDeviceInt(device);
        this.update(this, device);
    }

    private void addDeviceInt(DeviceInfo device) {
        device.addObserver(this);
        this.device_map.put(device.getAddress(), device);
    }

    public void removeDevice(DeviceInfo device) {
        if (device != null) {
            device.deleteObserver(this);
            this.device_map.remove(device.getAddress());
            this.update(this, device);
        }
    }

    public int[] enumDevices() {
        int[] device_numbers = new int[this.device_map.size()];
        int cur_idx = 0;
        for (Integer number : this.device_map.keySet()) {
            device_numbers[cur_idx++] = number;
        }
        return device_numbers;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.saveConfiguration();
        this.setChanged();
        this.notifyObservers();
    }

    public DeviceInfo getDevice(int number) {
        return this.device_map.get(number);
    }

    public Integer[] getAvailableDeviceNumbers() {
        Integer[] device_numbers = new Integer[28 - this.device_map.size()];
        int idx = 0;
        int number = 4;
        while (number < 32) {
            if (!this.device_map.containsKey(number)) {
                device_numbers[idx++] = number;
            }
            ++number;
        }
        return device_numbers;
    }
}

