/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals.iec;

import emulator.hardware.io.peripherals.iec.IecSim;
import emulator.hardware.io.peripherals.iec.IecSimDevice;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IecSimFilePrinter
implements IecSimDevice {
    static Logger logger = LogManager.getLogger((String)IecSimFilePrinter.class.getName());
    private IecSim _iecSim = null;
    private FileOutputStream _outputStream = null;
    private File _outFile = null;

    public IecSimFilePrinter(String fileName) {
        logger.info("Printing to file " + fileName);
        this._outFile = new File(fileName);
        try {
            this._outFile.createNewFile();
            if (!this._outFile.canWrite()) {
                logger.warn("Cannot write to file " + fileName);
            }
        }
        catch (IOException ex) {
            logger.error("File does not exists and cannot create file " + fileName, (Throwable)ex);
            this._outFile = null;
        }
    }

    @Override
    public void setIecSim(IecSim iecSim) {
        this._iecSim = iecSim;
    }

    @Override
    public void processCommand(ByteBuffer data) {
        this.processData(data);
    }

    @Override
    public void processData(ByteBuffer data) {
        if (this._outputStream != null) {
            try {
                this._outputStream.getChannel().write(data);
            }
            catch (IOException ex) {
                logger.error("Cannot write data to file " + this._outFile.getName(), (Throwable)ex);
            }
        }
    }

    @Override
    public void unlisten() {
        try {
            this._outputStream.close();
        }
        catch (IOException ex) {
            logger.error("Cannot close file " + this._outFile.getName(), (Throwable)ex);
        }
        this._outputStream = null;
    }

    @Override
    public void listen() {
        logger.entry();
        try {
            this._outputStream = new FileOutputStream(this._outFile, true);
            this._iecSim.initReceive(this);
        }
        catch (FileNotFoundException ex) {
            logger.error("Cannot open file " + this._outFile.getName(), (Throwable)ex);
        }
    }

    @Override
    public void talk() {
        logger.warn("Printers can't talk!");
    }

    @Override
    public void untalk() {
    }

    @Override
    public int read() {
        logger.warn("Reading from printer not supported!");
        return -1;
    }

    @Override
    public void rewind(int offset) {
    }
}

