/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.porthistory;

import emulator.hardware.io.Via6522;
import emulator.hardware.io.porthistory.PortStateCollector;
import emulator.history.BitStateHistory;
import emulator.util.events.EventAggregator;

public class PortStateHistory {
    private int bufSize = 1000;
    private BitStateHistory[] portAin = new BitStateHistory[8];
    private BitStateHistory[] portAout = new BitStateHistory[8];
    private BitStateHistory[] portActrl = new BitStateHistory[2];
    private BitStateHistory[] portBin = new BitStateHistory[8];
    private BitStateHistory[] portBout = new BitStateHistory[8];
    private BitStateHistory[] portBctrl = new BitStateHistory[2];

    public PortStateHistory(Via6522 via, EventAggregator eventAggregator) {
        int i = 0;
        while (i < 8) {
            this.portAin[i] = new BitStateHistory(this.bufSize);
            new PortStateCollector(eventAggregator, this.portAin[i], via, via.getPortA(), via.getPortA().getInPortBit(i));
            this.portAout[i] = new BitStateHistory(this.bufSize);
            new PortStateCollector(eventAggregator, this.portAout[i], via, via.getPortA(), via.getPortA().getOutPortBit(i));
            this.portBin[i] = new BitStateHistory(this.bufSize);
            new PortStateCollector(eventAggregator, this.portBin[i], via, via.getPortB(), via.getPortB().getInPortBit(i));
            this.portBout[i] = new BitStateHistory(this.bufSize);
            new PortStateCollector(eventAggregator, this.portBout[i], via, via.getPortB(), via.getPortB().getOutPortBit(i));
            ++i;
        }
        i = 0;
        while (i < 2) {
            this.portActrl[i] = new BitStateHistory(this.bufSize);
            new PortStateCollector(eventAggregator, this.portActrl[i], via, via.getPortA(), via.getPortA().getControlBit(i));
            this.portBctrl[i] = new BitStateHistory(this.bufSize);
            new PortStateCollector(eventAggregator, this.portBctrl[i], via, via.getPortB(), via.getPortB().getControlBit(i));
            ++i;
        }
    }

    public BitStateHistory getPortAin(int index) {
        return this.portAin[index];
    }

    public BitStateHistory getPortAout(int index) {
        return this.portAout[index];
    }

    public BitStateHistory getPortActrl(int index) {
        return this.portActrl[index];
    }

    public BitStateHistory getPortBin(int index) {
        return this.portBin[index];
    }

    public BitStateHistory getPortBout(int index) {
        return this.portBout[index];
    }

    public BitStateHistory getPortBctrl(int index) {
        return this.portBctrl[index];
    }
}

