/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.memory;

import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.memory.UnmappedMemoryException;
import java.util.Arrays;

public class CountingMemoryBlock
extends MemoryBlock {
    int[] read_counter;
    int[] write_counter;

    public CountingMemoryBlock(int size) {
        super(size);
        this.read_counter = new int[size];
        this.write_counter = new int[size];
        this.resetCounter();
    }

    public void resetCounter() {
        Arrays.fill(this.read_counter, 0);
        Arrays.fill(this.write_counter, 0);
    }

    @Override
    public int read(int address) throws UnmappedMemoryException, BusWatchException {
        int n = address;
        this.read_counter[n] = this.read_counter[n] + 1;
        return super.read(address);
    }

    @Override
    public void write(int address, int data) throws UnmappedMemoryException, BusWatchException {
        int n = address;
        this.write_counter[n] = this.write_counter[n] + 1;
        super.write(address, data);
    }

    public int[] getReadCounter() {
        return this.read_counter;
    }

    public int[] getWriteCounter() {
        return this.write_counter;
    }

    public boolean wasWritten(int address) {
        return this.write_counter[address] > 0;
    }
}

