/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.memory;

import emulator.hardware.HwWord;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.DebugMemoryFlags;
import emulator.hardware.memory.DebugMemoryInterface;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.memory.UnmappedMemoryException;

public class DebugMemoryBlock
extends MemoryBlock
implements DebugMemoryInterface {
    DebugMemoryFlags[] flags;

    public DebugMemoryBlock(int size) {
        super(size);
        this.flags = new DebugMemoryFlags[size];
        int i = 0;
        while (i < size) {
            this.flags[i] = new DebugMemoryFlags();
            ++i;
        }
    }

    @Override
    public synchronized int read(int address) throws UnmappedMemoryException, BusWatchException {
        if (address >= this.getData().length) {
            throw new UnmappedMemoryException(new HwWord((long)address));
        }
        if (this.flags[address].isReadWatch()) {
            throw new BusWatchException("read", new HwWord((long)address));
        }
        return this.getData()[address] & 0xFF;
    }

    @Override
    public synchronized void write(int address, int data) throws UnmappedMemoryException, BusWatchException {
        if (address >= this.getData().length) {
            throw new UnmappedMemoryException(new HwWord((long)address));
        }
        if (this.flags[address].isWriteWatch()) {
            throw new BusWatchException("write", new HwWord((long)address));
        }
        if (!this.flags[address].isReadOnly()) {
            this.getData()[address] = (byte)data;
        }
    }

    @Override
    public synchronized void enableReadWatch(int first, int last, boolean enable) {
        int i = first;
        while (i <= last) {
            this.flags[i].setReadWatch(enable);
            ++i;
        }
    }

    @Override
    public synchronized void enableWriteWatch(int first, int last, boolean enable) {
        int i = first;
        while (i <= last) {
            this.flags[i].setWriteWatch(enable);
            ++i;
        }
    }

    @Override
    public void enableReadonly(int first, int last, boolean enable) {
        int i = first;
        while (i <= last) {
            this.flags[i].setReadOnly(enable);
            ++i;
        }
    }
}

