/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502;

public class FloatHelper {
    public static double fromMFLPT(int[] bytes) {
        int exponent = bytes[0] - 160;
        double mantisse = 0.0;
        int i = 1;
        while (i < 5) {
            mantisse = mantisse * 256.0 + (double)bytes[i];
            ++i;
        }
        int sign = 1;
        if ((bytes[1] & 0x80) != 0) {
            sign = -1;
        } else {
            mantisse += 2.147483648E9;
        }
        return (double)sign * mantisse * Math.pow(2.0, exponent);
    }

    public static double fromFLPT(int[] bytes) {
        int exponent = bytes[0] - 160;
        double mantisse = 0.0;
        int i = 1;
        while (i < 5) {
            mantisse = mantisse * 256.0 + (double)bytes[i];
            ++i;
        }
        int sign = bytes[5] > 127 ? -1 : 1;
        return (double)sign * mantisse * Math.pow(2.0, exponent);
    }
}

