/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.AbsoluteX;
import emulator.hardware.nmos6502.operands.AbsoluteY;
import emulator.hardware.nmos6502.operands.Immediate;
import emulator.hardware.nmos6502.operands.IndirectX;
import emulator.hardware.nmos6502.operands.IndirectY;
import emulator.hardware.nmos6502.operands.ZeroPage;
import emulator.hardware.nmos6502.operands.ZeroPageX;

public class ADC
implements Command {
    @Override
    public String getName() {
        return "ADC";
    }

    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        int accu_old = (int)cpu.getAccu().getNumber();
        Flags6502 flags = cpu.getFlags();
        int op = (int)operand.getByte().getNumber();
        int accu = 0;
        accu = flags.getDecimal() ? this.addDecimal(accu_old, flags, op) : this.addBinary(accu_old, flags, op);
        cpu.setAccu(new HwByte((long)accu));
        cpu.setFlags(flags);
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(105, this, new Immediate());
        cset.defineCommand(101, this, new ZeroPage());
        cset.defineCommand(117, this, new ZeroPageX());
        cset.defineCommand(109, this, new Absolute());
        cset.defineCommand(125, this, new AbsoluteX());
        cset.defineCommand(121, this, new AbsoluteY());
        cset.defineCommand(97, this, new IndirectX());
        cset.defineCommand(113, this, new IndirectY());
    }

    private int addBinary(int accu_in, Flags6502 flags, int op) {
        int accu = accu_in + op;
        if (flags.getCarry()) {
            ++accu;
        }
        if (accu_in > 127) {
            accu_in -= 256;
        }
        if (op > 127) {
            op -= 256;
        }
        int signed_result = accu_in + op;
        if (flags.getCarry()) {
            ++signed_result;
        }
        flags.setCarry(accu > 255);
        flags.setNZFromValue(accu &= 0xFF);
        flags.setOverflow(signed_result < -128 || signed_result > 127);
        return accu;
    }

    private int addDecimal(int accu_in, Flags6502 flags, int op) {
        int accu = 0;
        int borrow = flags.getCarry() ? 1 : 0;
        int nibble1 = accu_in & 0xF;
        int nibble2 = op & 0xF;
        int sum = nibble1 + nibble2 + borrow;
        borrow = sum / 10;
        accu += (sum %= 10);
        nibble1 = (accu_in & 0xF0) >> 4;
        nibble2 = (op & 0xF0) >> 4;
        sum = nibble1 + nibble2 + borrow;
        borrow = sum / 10;
        flags.setCarry(borrow > 0);
        flags.setNZFromValue(accu += (sum %= 10) << 4);
        flags.setOverflow(false);
        return accu;
    }
}

