/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.ZeroPage;

public class BIT
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        HwByte value = operand.getByte();
        Flags6502 flags = cpu.getFlags();
        flags.setNegative(value.getBit(7));
        flags.setOverflow(value.getBit(6));
        value.and(cpu.getAccu());
        flags.setZero(value.isZero());
        cpu.setFlags(flags);
    }

    @Override
    public String getName() {
        return "BIT";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(36, this, new ZeroPage());
        cset.defineCommand(44, this, new Absolute());
    }
}

