/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.hardware.HwByte;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.commands.IllegalOpcodeException;
import emulator.hardware.nmos6502.operands.NoOperand;
import emulator.hardware.nmos6502.operands.OperandException;

public class INX
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws OperandException, UnmappedMemoryException, IllegalOpcodeException {
        HwByte value = cpu.getX();
        value.inc(1);
        Flags6502 flags = cpu.getFlags();
        flags.setNZFromValue(value);
        cpu.setFlags(flags);
        cpu.setX(value);
    }

    @Override
    public String getName() {
        return "INX";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(232, this, new NoOperand());
    }
}

