/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.AbsoluteY;
import emulator.hardware.nmos6502.operands.Immediate;
import emulator.hardware.nmos6502.operands.ZeroPage;
import emulator.hardware.nmos6502.operands.ZeroPageY;

public class LDX
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        HwByte value = operand.getByte();
        Flags6502 flags = cpu.getFlags();
        flags.setNZFromValue(value);
        cpu.setX(value);
        cpu.setFlags(flags);
    }

    @Override
    public String getName() {
        return "LDX";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(162, this, new Immediate());
        cset.defineCommand(166, this, new ZeroPage());
        cset.defineCommand(182, this, new ZeroPageY());
        cset.defineCommand(174, this, new Absolute());
        cset.defineCommand(190, this, new AbsoluteY());
    }
}

