/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.AbsoluteX;
import emulator.hardware.nmos6502.operands.Immediate;
import emulator.hardware.nmos6502.operands.ZeroPage;
import emulator.hardware.nmos6502.operands.ZeroPageX;

public class LDY
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        HwByte value = operand.getByte();
        cpu.setY(value);
        Flags6502 flags = cpu.getFlags();
        flags.setNZFromValue(value);
        cpu.setFlags(flags);
    }

    @Override
    public String getName() {
        return "LDY";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(160, this, new Immediate());
        cset.defineCommand(164, this, new ZeroPage());
        cset.defineCommand(180, this, new ZeroPageX());
        cset.defineCommand(172, this, new Absolute());
        cset.defineCommand(188, this, new AbsoluteX());
    }
}

