/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.AbsoluteX;
import emulator.hardware.nmos6502.operands.AbsoluteY;
import emulator.hardware.nmos6502.operands.IndirectX;
import emulator.hardware.nmos6502.operands.IndirectY;
import emulator.hardware.nmos6502.operands.ZeroPage;
import emulator.hardware.nmos6502.operands.ZeroPageX;

public class STA
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        operand.setByte(cpu.getAccu());
    }

    @Override
    public String getName() {
        return "STA";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(133, this, new ZeroPage());
        cset.defineCommand(149, this, new ZeroPageX());
        cset.defineCommand(141, this, new Absolute());
        cset.defineCommand(157, this, new AbsoluteX());
        cset.defineCommand(153, this, new AbsoluteY(false), 3);
        cset.defineCommand(129, this, new IndirectX());
        cset.defineCommand(145, this, new IndirectY());
    }
}

