/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.operands;

import emulator.assembler.SymbolTable;
import emulator.hardware.HwWord;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.operands.ByteOperand;
import emulator.support.AbsoluteXOperandEval;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class AbsoluteX
extends ByteOperand {
    private boolean add_cycles_on_crossing = true;
    private HwWord abs_addr = new HwWord();

    public AbsoluteX() {
    }

    public AbsoluteX(boolean add_cycles_on_crossing) {
        this.add_cycles_on_crossing = add_cycles_on_crossing;
    }

    @Override
    public void init(Cpu6502 cpu) throws UnmappedMemoryException, BusWatchException {
        super.init(cpu);
        HwWord addr = new HwWord((long)cpu.fetchProgramWord());
        this.abs_addr.setNumber(addr.getNumber());
        addr.add(cpu.getX());
        this.setAddress(addr);
    }

    @Override
    public String getString() {
        return "$" + this.abs_addr + ",X";
    }

    @Override
    public int getByteCount() {
        return 2;
    }

    @Override
    public String getString(MemoryPtr mem_ref, SymbolTable symbols) {
        return String.valueOf(symbols.getLabelOrAddress(mem_ref.getWordOp())) + ",X";
    }

    @Override
    public int getExtraCycles() {
        if (this.add_cycles_on_crossing && !this.abs_addr.hi().equals(this.getAddress().hi())) {
            return 3;
        }
        return 2;
    }

    @Override
    public OperandEval getEvaluator(MemoryPtr mem_ref) {
        return new AbsoluteXOperandEval(mem_ref);
    }
}

