/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.operands;

import emulator.assembler.SymbolTable;
import emulator.hardware.HwWord;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.operands.ByteOperand;
import emulator.support.AbsoluteYOperandEval;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class AbsoluteY
extends ByteOperand {
    private boolean add_page_crossing = true;
    private HwWord abs_addr = new HwWord();

    public AbsoluteY() {
    }

    public AbsoluteY(boolean add_page_crossing) {
        this.add_page_crossing = add_page_crossing;
    }

    @Override
    public void init(Cpu6502 cpu) throws UnmappedMemoryException, BusWatchException {
        super.init(cpu);
        HwWord addr = new HwWord((long)cpu.fetchProgramWord());
        this.abs_addr.setNumber(addr.getNumber());
        addr.add(cpu.getY());
        this.setAddress(addr);
    }

    @Override
    public String getString() {
        return "$" + this.abs_addr + ",Y";
    }

    @Override
    public int getByteCount() {
        return 2;
    }

    @Override
    public String getString(MemoryPtr mem_ref, SymbolTable symbols) {
        return String.valueOf(symbols.getLabelOrAddress(mem_ref.getWordOp())) + ",Y";
    }

    @Override
    public int getExtraCycles() {
        if (this.add_page_crossing && !this.abs_addr.hi().equals(this.getAddress().hi())) {
            return 3;
        }
        return 2;
    }

    @Override
    public OperandEval getEvaluator(MemoryPtr mem_ref) {
        return new AbsoluteYOperandEval(mem_ref);
    }
}

